/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.config_util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.KType;
import kotlin.reflect.KVisibility;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.config_util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.interfaces.ConfigSerializable;
import me.fzzyhmstrs.fzzy_config.interfaces.OldClass;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\"\u0010#J-\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\"\b\b\u0000\u0010\u0002*\u00020\u00012\u0006\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010JA\u0010\u0014\u001a\u00028\u0000\"\b\b\u0000\u0010\u0002*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J]\u0010\u0019\u001a\u00028\u0000\"\b\b\u0000\u0010\u0002*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00170\u0012\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lme/fzzyhmstrs/fzzy_config/config_util/SyncedConfigHelperV1;", "", "T", "config", "Lcom/google/gson/JsonElement;", "json", "Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "deserializeConfig", "(Ljava/lang/Object;Lcom/google/gson/JsonElement;)Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "", "child", "base", "Lkotlin/Pair;", "Ljava/io/File;", "", "makeDir", "(Ljava/lang/String;Ljava/lang/String;)Lkotlin/Pair;", "file", "Lkotlin/Function0;", "configClass", "readOrCreateAndValidate", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "previous", "Lme/fzzyhmstrs/fzzy_config/interfaces/OldClass;", "previousClass", "readOrCreateUpdatedAndValidate", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "serializeConfig", "(Ljava/lang/Object;)Ljava/lang/String;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "<init>", "()V", "fzzy_config"})
public final class SyncedConfigHelperV1 {
    @NotNull
    public static final SyncedConfigHelperV1 INSTANCE = new SyncedConfigHelperV1();
    @NotNull
    private static final Gson gson;

    private SyncedConfigHelperV1() {
    }

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final <T> T readOrCreateAndValidate(@NotNull String file, @NotNull String child, @NotNull String base, @NotNull Function0<? extends T> configClass) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        Pair<File, Boolean> pair = this.makeDir(child, base);
        File dir = (File)pair.component1();
        boolean dirCreated = (Boolean)pair.component2();
        if (!dirCreated) {
            return (T)configClass.invoke();
        }
        File f = new File(dir, file);
        try {
            if (f.exists()) {
                String str = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)f, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                Object object = configClass.invoke();
                JsonElement jsonElement = JsonParser.parseString((String)str);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseString(str)");
                ValidationResult<Object> readConfig = this.deserializeConfig(object, jsonElement);
                if (readConfig.isError()) {
                    FC.INSTANCE.getLOGGER().warn("Errors found in " + file + " per above log entries, attempting to correct invalid inputs automatically.");
                    String correctedConfig = this.serializeConfig(readConfig.get());
                    FilesKt.writeText$default((File)f, (String)correctedConfig, null, (int)2, null);
                }
                return (T)readConfig.get();
            }
            if (!f.createNewFile()) {
                FC.INSTANCE.getLOGGER().error("Failed to create default config file (" + file + "), using default config.");
            } else {
                Object initialClass = configClass.invoke();
                String str = this.serializeConfig(initialClass);
                FilesKt.writeText$default((File)f, (String)str, null, (int)2, null);
            }
            return (T)configClass.invoke();
        }
        catch (Exception e) {
            FC.INSTANCE.getLOGGER().error("Failed to read config file " + file + "! Using default values: " + e.getMessage());
            e.printStackTrace();
            return (T)configClass.invoke();
        }
    }

    public static /* synthetic */ Object readOrCreateAndValidate$default(SyncedConfigHelperV1 syncedConfigHelperV1, String string, String string2, String string3, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "fzzy_config";
        }
        return syncedConfigHelperV1.readOrCreateAndValidate(string, string2, string3, function0);
    }

    @NotNull
    public final <T> T readOrCreateUpdatedAndValidate(@NotNull String file, @NotNull String previous, @NotNull String child, @NotNull String base, @NotNull Function0<? extends T> configClass, @NotNull Function0<? extends OldClass<T>> previousClass) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(configClass, (String)"configClass");
        Intrinsics.checkNotNullParameter(previousClass, (String)"previousClass");
        Pair<File, Boolean> pair = this.makeDir(child, base);
        File dir = (File)pair.component1();
        boolean dirCreated = (Boolean)pair.component2();
        if (!dirCreated) {
            return (T)configClass.invoke();
        }
        File p = new File(dir, previous);
        try {
            if (p.exists()) {
                String pStr = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)p, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                Object object = previousClass.invoke();
                JsonElement jsonElement = JsonParser.parseString((String)pStr);
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parseString(pStr)");
                ValidationResult<Object> previousConfig = this.deserializeConfig(object, jsonElement);
                if (previousConfig.isError()) {
                    FC.INSTANCE.getLOGGER().error("Old config " + previous + " had errors, attempted to correct before updating.");
                }
                Object newClass = ((OldClass)previousConfig.get()).generateNewClass();
                File f = new File(dir, file);
                if (f.exists()) {
                    p.delete();
                    String str = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)f, null, (int)1, null), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                    Object object2 = configClass.invoke();
                    JsonElement jsonElement2 = JsonParser.parseString((String)str);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"parseString(str)");
                    ValidationResult<Object> readConfig = this.deserializeConfig(object2, jsonElement2);
                    if (readConfig.isError()) {
                        FC.INSTANCE.getLOGGER().warn("Errors found in " + file + " per above logs, attempting to correct invalid inputs automatically.");
                        String correctedConfig = this.serializeConfig(readConfig.get());
                        FilesKt.writeText$default((File)f, (String)correctedConfig, null, (int)2, null);
                    }
                    return (T)readConfig.get();
                }
                if (!f.createNewFile()) {
                    System.out.println((Object)("Failed to create new config file (" + file + "), using old config with new defaults."));
                } else {
                    p.delete();
                    FilesKt.writeText$default((File)f, (String)this.serializeConfig(newClass), null, (int)2, null);
                }
                return newClass;
            }
            return this.readOrCreateAndValidate(file, child, base, configClass);
        }
        catch (Exception e) {
            System.out.println((Object)("Failed to read config file " + file + "! Using default values: " + e.getMessage()));
            e.printStackTrace();
            return (T)configClass.invoke();
        }
    }

    public static /* synthetic */ Object readOrCreateUpdatedAndValidate$default(SyncedConfigHelperV1 syncedConfigHelperV1, String string, String string2, String string3, String string4, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "fzzy_config";
        }
        return syncedConfigHelperV1.readOrCreateUpdatedAndValidate(string, string2, string3, string4, function0, function02);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String serializeConfig(@NotNull Object config) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JsonObject json = new JsonObject();
        Object[] fields = config.getClass().getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
        Iterable $this$associate$iv = ArraysKt.withIndex((Object[])fields);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((Field)it.getValue()).getName(), (Object)it.getIndex());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map orderById = destination$iv$iv;
        Iterable $this$sortedBy$iv = KClasses.getMemberProperties((KClass)JvmClassMappingKt.getKotlinClass(config.getClass()));
        boolean $i$f$sortedBy = false;
        for (KProperty1 it : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderById){
            final /* synthetic */ Map $orderById$inlined;
            {
                this.$orderById$inlined = map;
            }

            public final int compare(T a, T b) {
                KProperty1 it = (KProperty1)a;
                boolean bl = false;
                Comparable comparable = (Integer)this.$orderById$inlined.get(it.getName());
                it = (KProperty1)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderById$inlined.get(it.getName())));
            }
        })) {
            if (!(it instanceof KMutableProperty) || it.getVisibility() != KVisibility.PUBLIC) continue;
            Object propVal = it.get(config);
            String name = it.getName();
            JsonElement el = propVal instanceof ConfigSerializable ? ((ConfigSerializable)propVal).serialize() : gson.toJsonTree(propVal, ReflectJvmMapping.getJavaType((KType)it.getReturnType()));
            json.add(name, el);
        }
        String string = gson.toJson((JsonElement)json);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(json)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> ValidationResult<T> deserializeConfig(@NotNull T config, @NotNull JsonElement json) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (!json.isJsonObject()) {
            return ValidationResult.Companion.error(config, "Config " + config.getClass().getCanonicalName() + " is corrupted or improperly formatted for parsing");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        boolean error = false;
        Object[] fields = config.getClass().getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
        Iterable $this$associate$iv = ArraysKt.withIndex((Object[])fields);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((Field)it.getValue()).getName(), (Object)it.getIndex());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map orderById = destination$iv$iv;
        Iterable $this$sortedBy$iv = KClasses.getMemberProperties((KClass)JvmClassMappingKt.getKotlinClass(config.getClass()));
        boolean $i$f$sortedBy = false;
        for (KProperty1 it : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderById){
            final /* synthetic */ Map $orderById$inlined;
            {
                this.$orderById$inlined = map;
            }

            public final int compare(T a, T b) {
                KProperty1 it = (KProperty1)a;
                boolean bl = false;
                Comparable comparable = (Integer)this.$orderById$inlined.get(it.getName());
                it = (KProperty1)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderById$inlined.get(it.getName())));
            }
        })) {
            if (!(it instanceof KMutableProperty)) continue;
            Object propVal = it.get(config);
            String name = it.getName();
            if (!jsonObject.has(name)) {
                error = true;
                continue;
            }
            JsonElement jsonElement = jsonObject.get(name);
            if (propVal instanceof ConfigSerializable) {
                ConfigSerializable configSerializable = (ConfigSerializable)propVal;
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonElement");
                ValidationResult<Boolean> result = configSerializable.deserialize(jsonElement, name);
                if (!result.isError()) continue;
                error = true;
                continue;
            }
            Object[] objectArray = new Object[]{config, gson.fromJson(jsonElement, ReflectJvmMapping.getJavaType((KType)it.getReturnType()))};
            ((KMutableProperty)it).getSetter().call(objectArray);
        }
        return !error ? ValidationResult.Companion.success(config) : ValidationResult.Companion.error(config, "Errors found!");
    }

    @NotNull
    public final Pair<File, Boolean> makeDir(@NotNull String child, @NotNull String base) {
        File dir;
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        File file = !Intrinsics.areEqual((Object)child, (Object)"") ? new File(new File(FabricLoader.getInstance().getConfigDir().toFile(), base), child) : (dir = !Intrinsics.areEqual((Object)base, (Object)"") ? new File(FabricLoader.getInstance().getConfigDir().toFile(), base) : FabricLoader.getInstance().getConfigDir().toFile());
        if (!dir.exists() && !dir.mkdirs()) {
            System.out.println((Object)"Could not create directory, using default configs.");
            return new Pair((Object)dir, (Object)false);
        }
        return new Pair((Object)dir, (Object)true);
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().setPrettyPrinting().create()");
        SyncedConfigHelperV1.gson = gson;
    }
}

