/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.rendering.shader;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.rendering.FabricShaderProgram;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(targets={"net.minecraft.client.gl.ShaderProgram$1"})
abstract class ShaderProgramImportProcessorMixin {
    @Unique
    private String capturedImport;

    ShaderProgramImportProcessorMixin() {
    }

    @Inject(method={"loadImport"}, at={@At(value="HEAD")})
    private void captureImport(boolean inline, String name, CallbackInfoReturnable<String> info) {
        this.capturedImport = name;
    }

    @ModifyVariable(method={"loadImport"}, at=@At(value="STORE"), ordinal=0, argsOnly=true)
    private String modifyImportId(String id, boolean inline) {
        if (!inline && this.capturedImport.contains(String.valueOf(':'))) {
            return FabricShaderProgram.rewriteAsId(id, this.capturedImport);
        }
        return id;
    }

    @Inject(method={"loadImport"}, at={@At(value="RETURN")})
    private void uncaptureImport(boolean inline, String name, CallbackInfoReturnable<String> info) {
        this.capturedImport = null;
    }
}

