/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.test;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.ShadowProcessor;
import io.determann.shadow.api.test.ProcessingCallback;
import io.determann.shadow.api.test.ProcessorTest;
import io.determann.shadow.impl.test.NonWritingFileManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class ProcessorTestImpl
implements ProcessorTest {
    private final ProcessingCallback processingCallback;
    private final List<JavaFileObject> toCompile;
    private final List<String> options;
    private final List<String> compiledClassNames;

    private ProcessorTestImpl(ProcessingCallback processingCallback, List<JavaFileObject> toCompile, List<String> options, List<String> compiledClassNames) {
        this.processingCallback = processingCallback;
        this.toCompile = toCompile;
        this.options = options;
        this.compiledClassNames = compiledClassNames;
    }

    public ProcessorTestImpl(ProcessingCallback processingCallback) {
        this.processingCallback = processingCallback;
        this.toCompile = new ArrayList<JavaFileObject>();
        this.options = new ArrayList<String>();
        this.compiledClassNames = new ArrayList<String>();
        this.compiledClassNames.add(Object.class.getName());
    }

    @Override
    public ProcessorTest withCodeToCompile(File fileToCompile) {
        String sourceCode;
        if (!fileToCompile.getName().endsWith(".java")) {
            throw new IllegalArgumentException("can only compile .java files");
        }
        try {
            sourceCode = String.join((CharSequence)"\n", Files.readAllLines(fileToCompile.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.toCompile.add(this.createJavaFileObject(fileToCompile.toURI(), sourceCode));
        return new ProcessorTestImpl(this.processingCallback, this.toCompile, this.options, this.compiledClassNames);
    }

    @Override
    public ProcessorTest withCodeToCompile(String fileName, String code) {
        this.toCompile.add(this.createJavaFileObject(this.createUri(fileName), code));
        return new ProcessorTestImpl(this.processingCallback, this.toCompile, this.options, this.compiledClassNames);
    }

    @Override
    public ProcessorTest withOption(String option) {
        this.options.add(option);
        return new ProcessorTestImpl(this.processingCallback, this.toCompile, this.options, this.compiledClassNames);
    }

    @Override
    public ProcessorTest withCompiledClass(String qualifiedName) {
        this.compiledClassNames.add(qualifiedName);
        return new ProcessorTestImpl(this.processingCallback, this.toCompile, this.options, this.compiledClassNames);
    }

    @Override
    public ProcessorTest withCompiledClass(Class<?> aClass) {
        this.compiledClassNames.add(aClass.getName());
        return new ProcessorTestImpl(this.processingCallback, this.toCompile, this.options, this.compiledClassNames);
    }

    @Override
    public void compile() {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Objects.requireNonNull(compiler);
        JavaCompiler.CompilationTask compilerTask = compiler.getTask(null, new NonWritingFileManager(compiler.getStandardFileManager(null, null, null)), diagnostic -> {
            if (diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) {
                throw new IllegalStateException(diagnostic.toString());
            }
        }, this.options, this.compiledClassNames, this.toCompile);
        compilerTask.setProcessors(Collections.singletonList(this.createProcessor()));
        compilerTask.call();
    }

    private Processor createProcessor() {
        return new ShadowProcessor(){

            @Override
            public void process(ShadowApi shadowApi) {
                ProcessorTestImpl.this.processingCallback.process(shadowApi);
            }
        };
    }

    private SimpleJavaFileObject createJavaFileObject(URI uri, final String sourceCode) {
        return new SimpleJavaFileObject(uri, JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean b) {
                return sourceCode;
            }
        };
    }

    private URI createUri(String fileName) {
        try {
            return this.processingCallback.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().resolve(fileName);
        }
        catch (SecurityException | URISyntaxException e) {
            return URI.create(fileName);
        }
    }
}

