/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow.wraper;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.shadow.AnnotationUsage;
import io.determann.shadow.api.shadow.EnumConstant;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.api.wrapper.AnnotationValueTypeChooser;
import io.determann.shadow.impl.shadow.wraper.AnnotationUsageImpl;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class AnnotationValueTypeChooserImpl
implements AnnotationValueTypeChooser {
    private final ShadowApi shadowApi;
    private final AnnotationValue annotationValue;
    private final boolean defaultValue;

    AnnotationValueTypeChooserImpl(ShadowApi shadowApi, AnnotationValue annotationValue, boolean defaultValue) {
        this.shadowApi = shadowApi;
        this.annotationValue = annotationValue;
        this.defaultValue = defaultValue;
    }

    @Override
    public String asString() {
        return (String)this.annotationValue.getValue();
    }

    @Override
    public Boolean asBoolean() {
        return (Boolean)this.annotationValue.getValue();
    }

    @Override
    public Byte asByte() {
        return (Byte)this.annotationValue.getValue();
    }

    @Override
    public Short asShort() {
        return (Short)this.annotationValue.getValue();
    }

    @Override
    public Integer asInteger() {
        return (Integer)this.annotationValue.getValue();
    }

    @Override
    public Long asLong() {
        return (Long)this.annotationValue.getValue();
    }

    @Override
    public Character asCharacter() {
        return (Character)this.annotationValue.getValue();
    }

    @Override
    public Float asFloat() {
        return (Float)this.annotationValue.getValue();
    }

    @Override
    public Double asDouble() {
        return (Double)this.annotationValue.getValue();
    }

    @Override
    public Shadow<TypeMirror> asType() {
        return this.shadowApi.getShadowFactory().shadowFromType((TypeMirror)this.annotationValue.getValue());
    }

    @Override
    public EnumConstant asEnumConstant() {
        return (EnumConstant)this.shadowApi.getShadowFactory().shadowFromElement((Element)this.annotationValue.getValue());
    }

    @Override
    public AnnotationUsage asAnnotationUsage() {
        return AnnotationUsageImpl.from(this.shadowApi, (AnnotationMirror)this.annotationValue.getValue());
    }

    @Override
    public List<AnnotationValueTypeChooser> asListOfValues() {
        return ((Collection)this.annotationValue.getValue()).stream().map(annotationValue1 -> new AnnotationValueTypeChooserImpl(this.shadowApi, (AnnotationValue)annotationValue1, this.isDefaultValue())).map(AnnotationValueTypeChooser.class::cast).toList();
    }

    @Override
    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public AnnotationValue getAnnotationValue() {
        return this.annotationValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AnnotationValueTypeChooserImpl)) return false;
        AnnotationValueTypeChooserImpl that = (AnnotationValueTypeChooserImpl)o;
        if (this.isDefaultValue() != that.isDefaultValue()) return false;
        if (!Objects.equals(this.getAnnotationValue(), that.getAnnotationValue())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.getAnnotationValue(), this.isDefaultValue());
    }

    @Override
    public String toString() {
        return this.annotationValue.toString();
    }
}

