/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow.wraper;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.shadow.Annotation;
import io.determann.shadow.api.shadow.AnnotationUsage;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.wrapper.AnnotationValueTypeChooser;
import io.determann.shadow.impl.shadow.DeclaredImpl;
import io.determann.shadow.impl.shadow.wraper.AnnotationValueTypeChooserImpl;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public class AnnotationUsageImpl
extends DeclaredImpl
implements AnnotationUsage {
    private final ShadowApi shadowApi;
    private final AnnotationMirror annotationMirror;

    public static List<AnnotationUsage> from(ShadowApi shadowApi, Collection<? extends AnnotationMirror> annotationMirrors) {
        return annotationMirrors.stream().map(annotationMirror -> AnnotationUsageImpl.from(shadowApi, annotationMirror)).toList();
    }

    static AnnotationUsage from(ShadowApi shadowApi, AnnotationMirror annotationMirror) {
        return new AnnotationUsageImpl(shadowApi, annotationMirror);
    }

    private AnnotationUsageImpl(ShadowApi shadowApi, AnnotationMirror annotationMirror) {
        super(shadowApi, annotationMirror.getAnnotationType());
        this.shadowApi = shadowApi;
        this.annotationMirror = annotationMirror;
    }

    @Override
    public Map<Method, AnnotationValueTypeChooser> getValues() {
        LinkedHashMap<Method, AnnotationValueTypeChooser> result = new LinkedHashMap<Method, AnnotationValueTypeChooser>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> withoutDefaults = this.annotationMirror.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> withDefaults = this.shadowApi.getJdkApiContext().getProcessingEnv().getElementUtils().getElementValuesWithDefaults(this.annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : withDefaults.entrySet()) {
            result.put((Method)this.shadowApi.getShadowFactory().shadowFromElement(entry.getKey()), new AnnotationValueTypeChooserImpl(this.shadowApi, entry.getValue(), !withoutDefaults.containsKey(entry.getKey())));
        }
        return result;
    }

    @Override
    public Optional<AnnotationValueTypeChooser> getValue(String methodName) {
        return this.getValues().entrySet().stream().filter(entry -> ((Method)entry.getKey()).getSimpleName().equals(methodName)).map(Map.Entry::getValue).findAny();
    }

    @Override
    public AnnotationValueTypeChooser getValueOrThrow(String methodName) {
        return this.getValue(methodName).orElseThrow();
    }

    @Override
    public Annotation getAnnotation() {
        return (Annotation)this.getApi().getShadowFactory().shadowFromElement(this.getElement());
    }

    @Override
    public String toString() {
        return this.annotationMirror.toString();
    }

    @Override
    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getTypeKind(), this.getQualifiedName(), this.getModule(), this.getValues()});
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        AnnotationUsageImpl otherAnnotationUsage = (AnnotationUsageImpl)other;
        return Objects.equals(this.getQualifiedName(), otherAnnotationUsage.getQualifiedName()) && Objects.equals((Object)this.getTypeKind(), (Object)otherAnnotationUsage.getTypeKind()) && Objects.equals(this.getModule(), otherAnnotationUsage.getModule()) && Objects.equals(this.getValues(), otherAnnotationUsage.getValues());
    }
}

