/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow.module;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.shadow.Module;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.module.DirectiveKind;
import io.determann.shadow.api.shadow.module.Exports;
import io.determann.shadow.impl.shadow.module.DirectiveImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;

public class ExportsImpl
extends DirectiveImpl
implements Exports {
    private final ModuleElement.ExportsDirective exportsDirective;

    public ExportsImpl(ShadowApi shadowApi, ModuleElement.ExportsDirective exportsDirective) {
        super(shadowApi);
        this.exportsDirective = exportsDirective;
    }

    @Override
    public Package getPackage() {
        return (Package)this.getApi().getShadowFactory().shadowFromElement(this.exportsDirective.getPackage());
    }

    @Override
    public List<Module> getTargetModules() {
        return this.exportsDirective.getTargetModules() == null ? Collections.emptyList() : this.exportsDirective.getTargetModules().stream().map(moduleElement -> (Module)this.getApi().getShadowFactory().shadowFromElement((Element)moduleElement)).toList();
    }

    @Override
    public boolean toAll() {
        return this.getTargetModules().isEmpty();
    }

    @Override
    public DirectiveKind getKind() {
        return DirectiveKind.EXPORTS;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ExportsImpl otherExports = (ExportsImpl)other;
        return Objects.equals((Object)this.getKind(), (Object)otherExports.getKind()) && Objects.equals(this.getTargetModules(), otherExports.getTargetModules()) && Objects.equals(this.getPackage(), otherExports.getPackage());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getKind(), this.getPackage(), this.getTargetModules()});
    }

    public String toString() {
        return this.exportsDirective.toString();
    }
}

