/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.api.shadow.Wildcard;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;

public class WildcardImpl
extends ShadowImpl<WildcardType>
implements Wildcard {
    public WildcardImpl(ShadowApi shadowApi, WildcardType wildcardTypeMirror) {
        super(shadowApi, wildcardTypeMirror);
    }

    @Override
    public TypeKind getTypeKind() {
        return TypeKind.WILDCARD;
    }

    @Override
    public Optional<Shadow<TypeMirror>> getExtends() {
        TypeMirror extendsBound = ((WildcardType)this.getMirror()).getExtendsBound();
        if (extendsBound == null) {
            return Optional.empty();
        }
        return Optional.of(this.getApi().getShadowFactory().shadowFromType(extendsBound));
    }

    @Override
    public Optional<Shadow<TypeMirror>> getSuper() {
        TypeMirror superBound = ((WildcardType)this.getMirror()).getSuperBound();
        if (superBound == null) {
            return Optional.empty();
        }
        return Optional.of(this.getApi().getShadowFactory().shadowFromType(superBound));
    }

    @Override
    public Shadow<TypeMirror> erasure() {
        return this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().erasure((TypeMirror)this.getMirror()));
    }

    @Override
    public boolean contains(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().contains((TypeMirror)this.getMirror(), shadow.getMirror());
    }

    public int hashCode() {
        return Objects.hash(this.getExtends(), this.getSuper());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        WildcardImpl otherWildcard = (WildcardImpl)other;
        return Objects.equals(this.getExtends(), otherWildcard.getExtends()) && Objects.equals(this.getSuper(), otherWildcard.getSuper());
    }
}

