/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.api.shadow.Variable;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public abstract class VariableImpl<SURROUNDING extends Shadow<? extends TypeMirror>>
extends ShadowImpl<TypeMirror>
implements Variable<SURROUNDING> {
    private final VariableElement variableElement;

    protected VariableImpl(ShadowApi shadowApi, VariableElement variableElement) {
        super(shadowApi, variableElement.asType());
        this.variableElement = variableElement;
    }

    @Override
    public boolean isSubtypeOf(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isSubtype(shadow.getMirror(), (TypeMirror)this.getMirror());
    }

    @Override
    public boolean isAssignableFrom(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isAssignable(shadow.getMirror(), (TypeMirror)this.getMirror());
    }

    @Override
    public Shadow<TypeMirror> getType() {
        return this.getApi().getShadowFactory().shadowFromType(this.getElement().asType());
    }

    @Override
    public Package getPackage() {
        return (Package)this.getApi().getShadowFactory().shadowFromElement(this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getPackageOf(this.getElement()));
    }

    @Override
    public VariableElement getElement() {
        return this.variableElement;
    }

    @Override
    public TypeKind getTypeKind() {
        return switch (this.getElement().getKind()) {
            case ElementKind.ENUM_CONSTANT -> TypeKind.ENUM_CONSTANT;
            case ElementKind.FIELD -> TypeKind.FIELD;
            case ElementKind.PARAMETER -> TypeKind.PARAMETER;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    @Override
    public SURROUNDING getSurrounding() {
        return (SURROUNDING)this.getApi().getShadowFactory().shadowFromElement(this.getElement().getEnclosingElement());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTypeKind(), this.getSimpleName(), this.getSurrounding()});
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        VariableImpl otherVariable = (VariableImpl)other;
        return Objects.equals(this.getSimpleName(), otherVariable.getSimpleName()) && Objects.equals(this.getSurrounding(), otherVariable.getSurrounding()) && Objects.equals((Object)this.getTypeKind(), (Object)otherVariable.getTypeKind());
    }
}

