/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Record;
import io.determann.shadow.api.shadow.RecordComponent;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.Objects;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.type.TypeMirror;

public class RecordComponentImpl
extends ShadowImpl<TypeMirror>
implements RecordComponent {
    private final RecordComponentElement recordComponentElement;

    public RecordComponentImpl(ShadowApi shadowApi, RecordComponentElement recordComponentElement) {
        super(shadowApi, recordComponentElement.asType());
        this.recordComponentElement = recordComponentElement;
    }

    @Override
    public boolean isSubtypeOf(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isSubtype((TypeMirror)this.getMirror(), shadow.getMirror());
    }

    @Override
    public boolean isAssignableFrom(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isAssignable((TypeMirror)this.getMirror(), shadow.getMirror());
    }

    @Override
    public Record getRecord() {
        return (Record)this.getApi().getShadowFactory().shadowFromElement(this.getElement().getEnclosingElement());
    }

    @Override
    public Shadow<TypeMirror> getType() {
        return this.getApi().getShadowFactory().shadowFromType(this.getElement().asType());
    }

    @Override
    public Method getGetter() {
        return (Method)this.getApi().getShadowFactory().shadowFromElement(this.getElement().getAccessor());
    }

    @Override
    public Package getPackage() {
        return (Package)this.getApi().getShadowFactory().shadowFromElement(this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getPackageOf(this.getElement()));
    }

    @Override
    public RecordComponent erasure() {
        return (RecordComponent)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().erasure((TypeMirror)this.getMirror()));
    }

    @Override
    public RecordComponentElement getElement() {
        return this.recordComponentElement;
    }

    @Override
    public TypeKind getTypeKind() {
        return TypeKind.RECORD_COMPONENT;
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    public int hashCode() {
        return Objects.hash(this.getSimpleName(), this.getRecord());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        RecordComponentImpl otherRecordComponent = (RecordComponentImpl)other;
        return Objects.equals(this.getSimpleName(), otherRecordComponent.getSimpleName()) && Objects.equals(this.getRecord(), otherRecordComponent.getRecord());
    }
}

