/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.shadow.Array;
import io.determann.shadow.api.shadow.Class;
import io.determann.shadow.api.shadow.Primitive;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.Objects;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class PrimitiveImpl
extends ShadowImpl<PrimitiveType>
implements Primitive {
    public PrimitiveImpl(ShadowApi shadowApi, PrimitiveType primitiveTypeMirror) {
        super(shadowApi, primitiveTypeMirror);
    }

    @Override
    public boolean isSubtypeOf(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isSubtype(shadow.getMirror(), (TypeMirror)this.getMirror());
    }

    @Override
    public boolean isAssignableFrom(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isAssignable((TypeMirror)this.getMirror(), shadow.getMirror());
    }

    @Override
    public Class asBoxed() {
        return (Class)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().boxedClass((PrimitiveType)this.getMirror()).asType());
    }

    @Override
    public Array asArray() {
        return (Array)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().getArrayType((TypeMirror)this.getMirror()));
    }

    @Override
    public io.determann.shadow.api.TypeKind getTypeKind() {
        return switch (((PrimitiveType)this.getMirror()).getKind()) {
            case TypeKind.BOOLEAN -> io.determann.shadow.api.TypeKind.BOOLEAN;
            case TypeKind.BYTE -> io.determann.shadow.api.TypeKind.BYTE;
            case TypeKind.SHORT -> io.determann.shadow.api.TypeKind.SHORT;
            case TypeKind.INT -> io.determann.shadow.api.TypeKind.INT;
            case TypeKind.LONG -> io.determann.shadow.api.TypeKind.LONG;
            case TypeKind.CHAR -> io.determann.shadow.api.TypeKind.CHAR;
            case TypeKind.FLOAT -> io.determann.shadow.api.TypeKind.FLOAT;
            case TypeKind.DOUBLE -> io.determann.shadow.api.TypeKind.DOUBLE;
            default -> throw new IllegalStateException();
        };
    }

    public int hashCode() {
        return Objects.hashCode((Object)this.getTypeKind());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PrimitiveImpl otherPrimitive = (PrimitiveImpl)other;
        return Objects.equals((Object)this.getTypeKind(), (Object)otherPrimitive.getTypeKind());
    }
}

