/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;

public class PackageImpl
extends ShadowImpl<NoType>
implements Package {
    private final PackageElement packageElement;

    public PackageImpl(ShadowApi shadowApi, PackageElement packageElement) {
        super(shadowApi, (NoType)packageElement.asType());
        this.packageElement = packageElement;
    }

    public PackageImpl(ShadowApi shadowApi, NoType noTypeMirror) {
        super(shadowApi, noTypeMirror);
        this.packageElement = this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getPackageElement(noTypeMirror.toString());
        if (this.packageElement == null) {
            throw new IllegalStateException(noTypeMirror + " is not unique");
        }
    }

    @Override
    public List<Declared> getContent() {
        return this.getElement().getEnclosedElements().stream().map(TypeElement.class::cast).map(typeElement -> (Declared)this.getApi().getShadowFactory().shadowFromElement((Element)typeElement)).toList();
    }

    @Override
    public boolean isUnnamed() {
        return this.getElement().isUnnamed();
    }

    @Override
    public PackageElement getElement() {
        return this.packageElement;
    }

    @Override
    public TypeKind getTypeKind() {
        return TypeKind.PACKAGE;
    }

    @Override
    public List<Declared> getDeclared() {
        return this.getContent();
    }

    @Override
    public Declared getDeclaredOrThrow(String qualifiedName) {
        TypeElement typeElement = this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getTypeElement((ModuleElement)this.getModule().getElement(), qualifiedName);
        if (typeElement == null) {
            throw new IllegalArgumentException("no Declared found for \"" + qualifiedName + "\"");
        }
        return (Declared)this.getApi().getShadowFactory().shadowFromElement(typeElement);
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    public int hashCode() {
        return Objects.hash(this.getQualifiedName(), this.getModule());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        PackageImpl otherPackage = (PackageImpl)other;
        return Objects.equals(this.getQualifiedName(), otherPackage.getQualifiedName()) && Objects.equals(this.getModule(), otherPackage.getModule());
    }
}

