/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Module;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.api.shadow.module.Directive;
import io.determann.shadow.api.shadow.module.DirectiveConsumer;
import io.determann.shadow.api.shadow.module.DirectiveKind;
import io.determann.shadow.api.shadow.module.DirectiveMapper;
import io.determann.shadow.impl.shadow.ShadowImpl;
import io.determann.shadow.impl.shadow.module.ExportsImpl;
import io.determann.shadow.impl.shadow.module.OpensImpl;
import io.determann.shadow.impl.shadow.module.ProvidesImpl;
import io.determann.shadow.impl.shadow.module.RequiresImpl;
import io.determann.shadow.impl.shadow.module.UsesImpl;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;

public class ModuleImpl
extends ShadowImpl<NoType>
implements Module {
    private final ModuleElement moduleElement;

    public ModuleImpl(ShadowApi shadowApi, ModuleElement moduleElement) {
        super(shadowApi, (NoType)moduleElement.asType());
        this.moduleElement = moduleElement;
    }

    public ModuleImpl(ShadowApi shadowApi, NoType noType) {
        super(shadowApi, noType);
        this.moduleElement = this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getModuleElement(noType.toString());
        if (this.moduleElement == null) {
            throw new IllegalStateException(noType + " is not unique");
        }
    }

    @Override
    public TypeKind getTypeKind() {
        return TypeKind.MODULE;
    }

    @Override
    public ModuleElement getElement() {
        return this.moduleElement;
    }

    @Override
    public List<Package> getPackages() {
        return this.getElement().getEnclosedElements().stream().map(element -> (Package)this.getApi().getShadowFactory().shadowFromElement((Element)element)).toList();
    }

    @Override
    public List<Declared> getDeclared() {
        return this.getPackages().stream().flatMap(aPackage -> aPackage.getDeclared().stream()).toList();
    }

    @Override
    public Declared getDeclaredOrThrow(String qualifiedName) {
        TypeElement typeElement = this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getTypeElement(this.getElement(), qualifiedName);
        if (typeElement == null) {
            throw new IllegalArgumentException("no Declared found for \"" + qualifiedName + "\"");
        }
        return (Declared)this.getApi().getShadowFactory().shadowFromElement(typeElement);
    }

    @Override
    public boolean isOpen() {
        return this.getElement().isOpen();
    }

    @Override
    public boolean isUnnamed() {
        return this.getElement().isUnnamed();
    }

    @Override
    public boolean isAutomatic() {
        return this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().isAutomaticModule(this.getElement());
    }

    @Override
    public List<Directive> getDirectives() {
        return this.getElement().getDirectives().stream().map(directive -> switch (directive.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case ModuleElement.DirectiveKind.REQUIRES -> new RequiresImpl(this.getApi(), (ModuleElement.RequiresDirective)directive);
            case ModuleElement.DirectiveKind.EXPORTS -> new ExportsImpl(this.getApi(), (ModuleElement.ExportsDirective)directive);
            case ModuleElement.DirectiveKind.OPENS -> new OpensImpl(this.getApi(), (ModuleElement.OpensDirective)directive);
            case ModuleElement.DirectiveKind.USES -> new UsesImpl(this.getApi(), (ModuleElement.UsesDirective)directive);
            case ModuleElement.DirectiveKind.PROVIDES -> new ProvidesImpl(this.getApi(), (ModuleElement.ProvidesDirective)directive);
        }).map(Directive.class::cast).toList();
    }

    @Override
    public <T> List<T> mapDirectives(DirectiveMapper<T> mapper) {
        return this.getDirectives().stream().map(directive -> switch (directive.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case DirectiveKind.REQUIRES -> mapper.requires(ShadowApi.convert(directive).toRequiresOrThrow());
            case DirectiveKind.EXPORTS -> mapper.exports(ShadowApi.convert(directive).toExportsOrThrow());
            case DirectiveKind.OPENS -> mapper.opens(ShadowApi.convert(directive).toOpensOrThrow());
            case DirectiveKind.USES -> mapper.uses(ShadowApi.convert(directive).toUsesOrThrow());
            case DirectiveKind.PROVIDES -> mapper.provides(ShadowApi.convert(directive).toProvidesOrThrow());
        }).toList();
    }

    @Override
    public void consumeDirectives(DirectiveConsumer consumer) {
        this.getDirectives().forEach(directive -> {
            switch (directive.getKind()) {
                case REQUIRES: {
                    consumer.requires(ShadowApi.convert(directive).toRequiresOrThrow());
                    break;
                }
                case EXPORTS: {
                    consumer.exports(ShadowApi.convert(directive).toExportsOrThrow());
                    break;
                }
                case OPENS: {
                    consumer.opens(ShadowApi.convert(directive).toOpensOrThrow());
                    break;
                }
                case USES: {
                    consumer.uses(ShadowApi.convert(directive).toUsesOrThrow());
                    break;
                }
                case PROVIDES: {
                    consumer.provides(ShadowApi.convert(directive).toProvidesOrThrow());
                }
            }
        });
    }

    @Override
    public boolean representsSameType(Shadow<? extends TypeMirror> shadow) {
        return this.equals(shadow);
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    public int hashCode() {
        return Objects.hash(this.getQualifiedName());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ModuleImpl otherModule = (ModuleImpl)other;
        return Objects.equals(this.getQualifiedName(), otherModule.getQualifiedName());
    }
}

