/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Array;
import io.determann.shadow.api.shadow.Intersection;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.List;
import java.util.Objects;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;

public class IntersectionImpl
extends ShadowImpl<IntersectionType>
implements Intersection {
    public IntersectionImpl(ShadowApi shadowApi, IntersectionType intersectionType) {
        super(shadowApi, intersectionType);
    }

    @Override
    public TypeKind getTypeKind() {
        return TypeKind.INTERSECTION;
    }

    @Override
    public List<Shadow<TypeMirror>> getBounds() {
        return ((IntersectionType)this.getMirror()).getBounds().stream().map(typeMirror -> this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror)).toList();
    }

    @Override
    public Array asArray() {
        return (Array)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().getArrayType((TypeMirror)this.getMirror()));
    }

    @Override
    public Shadow<TypeMirror> erasure() {
        return this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().erasure((TypeMirror)this.getMirror()));
    }

    public int hashCode() {
        return Objects.hash(this.getBounds());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        IntersectionImpl otherIntersection = (IntersectionImpl)other;
        return Objects.equals(this.getBounds(), otherIntersection.getBounds());
    }
}

