/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.shadow.Generic;
import io.determann.shadow.api.shadow.Interface;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.shadow.DeclaredImpl;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class InterfaceImpl
extends DeclaredImpl
implements Interface {
    public InterfaceImpl(ShadowApi shadowApi, DeclaredType declaredTypeMirror) {
        super(shadowApi, declaredTypeMirror);
    }

    public InterfaceImpl(ShadowApi shadowApi, TypeElement typeElement) {
        super(shadowApi, typeElement);
    }

    @Override
    public boolean isFunctional() {
        return this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().isFunctionalInterface(this.getElement());
    }

    @Override
    @SafeVarargs
    public final Interface withGenerics(Shadow<? extends TypeMirror> ... generics) {
        if (generics.length == 0 || this.getFormalGenerics().size() != generics.length) {
            throw new IllegalArgumentException(this.getQualifiedName() + " has " + this.getFormalGenerics().size() + " generics. " + generics.length + " are provided");
        }
        TypeMirror[] typeMirrors = (TypeMirror[])Arrays.stream(generics).map(Shadow::getMirror).toArray(TypeMirror[]::new);
        return (Interface)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().getDeclaredType(this.getElement(), typeMirrors));
    }

    @Override
    public Interface withGenerics(String ... qualifiedGenerics) {
        return this.withGenerics((Shadow[])Arrays.stream(qualifiedGenerics).map(qualifiedName -> this.getApi().getDeclaredOrThrow((String)qualifiedName)).toArray(Shadow[]::new));
    }

    @Override
    public List<Shadow<TypeMirror>> getGenerics() {
        return ((DeclaredType)this.getMirror()).getTypeArguments().stream().map(typeMirror -> this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror)).toList();
    }

    @Override
    public List<Generic> getFormalGenerics() {
        return this.getElement().getTypeParameters().stream().map(element -> (Generic)this.getApi().getShadowFactory().shadowFromElement((Element)element)).toList();
    }

    @Override
    public Interface interpolateGenerics() {
        return (Interface)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().capture((TypeMirror)this.getMirror()));
    }

    @Override
    public Interface erasure() {
        return (Interface)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().erasure((TypeMirror)this.getMirror()));
    }
}

