/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Generic;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.Objects;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class GenericImpl
extends ShadowImpl<TypeVariable>
implements Generic {
    private final TypeParameterElement typeParameterElement;

    public GenericImpl(ShadowApi shadowApi, TypeParameterElement typeParameterElement) {
        super(shadowApi, (TypeVariable)typeParameterElement.asType());
        this.typeParameterElement = typeParameterElement;
    }

    public GenericImpl(ShadowApi shadowApi, TypeVariable typeMirror) {
        super(shadowApi, typeMirror);
        this.typeParameterElement = (TypeParameterElement)this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().asElement(typeMirror);
    }

    @Override
    public Shadow<TypeMirror> getExtends() {
        return this.getApi().getShadowFactory().shadowFromType(((TypeVariable)this.getMirror()).getUpperBound());
    }

    @Override
    public Shadow<TypeMirror> getSuper() {
        return this.getApi().getShadowFactory().shadowFromType(((TypeVariable)this.getMirror()).getLowerBound());
    }

    @Override
    public Shadow<TypeMirror> getEnclosing() {
        return this.getApi().getShadowFactory().shadowFromElement(this.getElement().getGenericElement());
    }

    @Override
    public TypeKind getTypeKind() {
        return TypeKind.GENERIC;
    }

    @Override
    public Package getPackage() {
        return (Package)this.getApi().getShadowFactory().shadowFromElement(this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getPackageOf(this.getElement()));
    }

    @Override
    public Shadow<TypeMirror> erasure() {
        return this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().erasure((TypeMirror)this.getMirror()));
    }

    @Override
    public TypeParameterElement getElement() {
        return this.typeParameterElement;
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    public int hashCode() {
        return Objects.hash(this.getSimpleName(), this.getExtends(), this.getSuper(), this.getEnclosing());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        GenericImpl otherGeneric = (GenericImpl)other;
        return Objects.equals(this.getSimpleName(), otherGeneric.getSimpleName()) && Objects.equals(this.getExtends(), otherGeneric.getExtends()) && Objects.equals(this.getSuper(), otherGeneric.getSuper()) && Objects.equals(this.getEnclosing(), otherGeneric.getEnclosing());
    }
}

