/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.converter.ShadowConverter;
import io.determann.shadow.api.shadow.Class;
import io.determann.shadow.api.shadow.Constructor;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Generic;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Parameter;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ExecutableImpl
extends ShadowImpl<ExecutableType>
implements Constructor,
Method {
    private final ExecutableElement executableElement;

    public ExecutableImpl(ShadowApi shadowApi, ExecutableElement executableElement) {
        super(shadowApi, (ExecutableType)executableElement.asType());
        this.executableElement = executableElement;
    }

    @Override
    public Shadow<TypeMirror> getReturnType() {
        return this.getApi().getShadowFactory().shadowFromType(((ExecutableType)this.getMirror()).getReturnType());
    }

    @Override
    public List<Shadow<TypeMirror>> getParameterTypes() {
        return ((ExecutableType)this.getMirror()).getParameterTypes().stream().map(typeMirror -> this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror)).toList();
    }

    @Override
    public Optional<Declared> getReceiverType() {
        TypeMirror receiverType = ((ExecutableType)this.getMirror()).getReceiverType();
        if (receiverType == null || receiverType.getKind().equals((Object)TypeKind.NONE)) {
            return Optional.empty();
        }
        return Optional.of((Declared)this.getApi().getShadowFactory().shadowFromType(receiverType));
    }

    @Override
    public List<Class> getThrows() {
        return ((ExecutableType)this.getMirror()).getThrownTypes().stream().map(typeMirror -> this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror)).map(ShadowApi::convert).map(ShadowConverter::toClassOrThrow).toList();
    }

    @Override
    public boolean isBridge() {
        return this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().isBridge(this.getElement());
    }

    @Override
    public boolean isVarArgs() {
        return this.getElement().isVarArgs();
    }

    @Override
    public Declared getSurrounding() {
        return (Declared)this.getApi().getShadowFactory().shadowFromElement(this.getElement().getEnclosingElement());
    }

    @Override
    public ExecutableElement getElement() {
        return this.executableElement;
    }

    @Override
    public io.determann.shadow.api.TypeKind getTypeKind() {
        return switch (this.getElement().getKind()) {
            case ElementKind.CONSTRUCTOR -> io.determann.shadow.api.TypeKind.CONSTRUCTOR;
            case ElementKind.METHOD -> io.determann.shadow.api.TypeKind.METHOD;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public boolean overrides(Method method) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().overrides(this.getElement(), (ExecutableElement)method.getElement(), (TypeElement)this.getSurrounding().getElement());
    }

    @Override
    public boolean overwrittenBy(Method method) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().overrides((ExecutableElement)method.getElement(), this.getElement(), (TypeElement)method.getSurrounding().getElement());
    }

    @Override
    public boolean sameParameterTypes(Method method) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isSubsignature((ExecutableType)this.getMirror(), (ExecutableType)method.getMirror());
    }

    @Override
    public List<Parameter> getParameters() {
        return this.getElement().getParameters().stream().map(variableElement -> (Parameter)this.getApi().getShadowFactory().shadowFromElement((Element)variableElement)).toList();
    }

    @Override
    public Parameter getParameterOrThrow(String name) {
        return this.getParameters().stream().filter(parameter -> parameter.getSimpleName().equals(name)).findAny().orElseThrow();
    }

    @Override
    public List<Generic> getFormalGenerics() {
        return this.getElement().getTypeParameters().stream().map(element -> (Generic)this.getApi().getShadowFactory().shadowFromElement((Element)element)).toList();
    }

    @Override
    public Package getPackage() {
        return (Package)this.getApi().getShadowFactory().shadowFromElement(this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getPackageOf(this.getElement()));
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTypeKind(), this.getSimpleName(), this.getParameterTypes(), this.getSurrounding()});
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ExecutableImpl otherExecutable = (ExecutableImpl)other;
        return Objects.equals(this.getSimpleName(), otherExecutable.getSimpleName()) && Objects.equals((Object)this.getTypeKind(), (Object)otherExecutable.getTypeKind()) && Objects.equals(this.getParameterTypes(), otherExecutable.getParameterTypes()) && Objects.equals(this.getSurrounding(), otherExecutable.getSurrounding());
    }
}

