/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.NestingKind;
import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.converter.DeclaredConverter;
import io.determann.shadow.api.shadow.Annotation;
import io.determann.shadow.api.shadow.Array;
import io.determann.shadow.api.shadow.Constructor;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Enum;
import io.determann.shadow.api.shadow.EnumConstant;
import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Interface;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.api.shadow.Wildcard;
import io.determann.shadow.impl.shadow.ShadowImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class DeclaredImpl
extends ShadowImpl<DeclaredType>
implements Annotation,
Enum {
    private final TypeElement typeElement;

    public DeclaredImpl(ShadowApi shadowApi, DeclaredType declaredTypeMirror) {
        super(shadowApi, declaredTypeMirror);
        this.typeElement = (TypeElement)declaredTypeMirror.asElement();
    }

    public DeclaredImpl(ShadowApi shadowApi, TypeElement typeElement) {
        super(shadowApi, (DeclaredType)typeElement.asType());
        this.typeElement = typeElement;
    }

    @Override
    public boolean isSubtypeOf(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isSubtype((TypeMirror)this.getMirror(), shadow.getMirror());
    }

    @Override
    public TypeKind getTypeKind() {
        return switch (this.getElement().getKind()) {
            case ElementKind.ENUM -> TypeKind.ENUM;
            case ElementKind.CLASS -> TypeKind.CLASS;
            case ElementKind.INTERFACE -> TypeKind.INTERFACE;
            case ElementKind.ANNOTATION_TYPE -> TypeKind.ANNOTATION;
            case ElementKind.RECORD -> TypeKind.RECORD;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public TypeElement getElement() {
        return this.typeElement;
    }

    @Override
    public NestingKind getNesting() {
        return switch (this.getElement().getNestingKind()) {
            case javax.lang.model.element.NestingKind.MEMBER -> NestingKind.INNER;
            case javax.lang.model.element.NestingKind.TOP_LEVEL -> NestingKind.OUTER;
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public Field getFieldOrThrow(String simpleName) {
        return this.getFields().stream().filter(field -> field.getSimpleName().equals(simpleName)).findAny().orElseThrow();
    }

    @Override
    public List<Field> getFields() {
        return this.getElement().getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.FIELD)).map(variableElement -> (Field)this.getApi().getShadowFactory().shadowFromElement((Element)variableElement)).toList();
    }

    @Override
    public List<Method> getMethods(String simpleName) {
        return this.getMethods().stream().filter(field -> field.getSimpleName().equals(simpleName)).toList();
    }

    @Override
    public List<Method> getMethods() {
        return ElementFilter.methodsIn(this.getElement().getEnclosedElements()).stream().map(element -> (Method)this.getApi().getShadowFactory().shadowFromElement((Element)element)).toList();
    }

    @Override
    public List<Constructor> getConstructors() {
        return ElementFilter.constructorsIn(this.getElement().getEnclosedElements()).stream().map(element -> (Constructor)this.getApi().getShadowFactory().shadowFromElement((Element)element)).toList();
    }

    @Override
    public List<Declared> getDirectSuperTypes() {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().directSupertypes((TypeMirror)this.getMirror()).stream().map(typeMirror1 -> (Declared)this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror1)).toList();
    }

    @Override
    public Set<Declared> getSuperTypes() {
        return this.findAllSupertypes(new HashSet<Declared>(), this);
    }

    private Set<Declared> findAllSupertypes(Set<Declared> found, Declared declared) {
        List<Declared> directSupertypes = declared.getDirectSuperTypes();
        found.addAll(directSupertypes);
        for (Declared directSupertype : directSupertypes) {
            this.findAllSupertypes(found, directSupertype);
        }
        return found;
    }

    @Override
    public String getBinaryName() {
        return this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getBinaryName(this.getElement()).toString();
    }

    @Override
    public Wildcard asExtendsWildcard() {
        return (Wildcard)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().getWildcardType((TypeMirror)this.getMirror(), null));
    }

    @Override
    public Wildcard asSuperWildcard() {
        return (Wildcard)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().getWildcardType(null, (TypeMirror)this.getMirror()));
    }

    @Override
    public Array asArray() {
        return (Array)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().getArrayType((TypeMirror)this.getMirror()));
    }

    @Override
    public List<Interface> getDirectInterfaces() {
        return this.getElement().getInterfaces().stream().map(typeMirror -> (Interface)this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror)).toList();
    }

    @Override
    public List<Interface> getInterfaces() {
        return this.getSuperTypes().stream().filter(declared -> declared.getTypeKind().equals((Object)TypeKind.INTERFACE)).map(ShadowApi::convert).map(DeclaredConverter::toInterfaceOrThrow).toList();
    }

    @Override
    public Interface getInterfaceOrThrow(String qualifiedName) {
        return this.getInterfaces().stream().filter(anInterface -> anInterface.getQualifiedName().equals(qualifiedName)).findAny().orElseThrow();
    }

    @Override
    public Interface getDirectInterfaceOrThrow(String qualifiedName) {
        return this.getDirectInterfaces().stream().filter(anInterface -> anInterface.getQualifiedName().equals(qualifiedName)).findAny().orElseThrow();
    }

    @Override
    public List<EnumConstant> getEumConstants() {
        return this.getElement().getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(VariableElement.class::cast).map(variableElement -> (EnumConstant)this.getApi().getShadowFactory().shadowFromElement((Element)variableElement)).toList();
    }

    @Override
    public EnumConstant getEnumConstantOrThrow(String simpleName) {
        return this.getEumConstants().stream().filter(field -> field.getSimpleName().equals(simpleName)).findAny().orElseThrow();
    }

    @Override
    public Package getPackage() {
        return (Package)this.getApi().getShadowFactory().shadowFromElement(this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getPackageOf(this.getElement()));
    }

    @Override
    public String toString() {
        return this.getElement().toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTypeKind(), this.getQualifiedName(), this.getModule()});
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        DeclaredImpl otherDeclared = (DeclaredImpl)other;
        return Objects.equals(this.getQualifiedName(), otherDeclared.getQualifiedName()) && Objects.equals((Object)this.getTypeKind(), (Object)otherDeclared.getTypeKind()) && Objects.equals(this.getModule(), otherDeclared.getModule());
    }
}

