/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.shadow;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.property.ImmutableProperty;
import io.determann.shadow.api.property.MutableProperty;
import io.determann.shadow.api.property.Property;
import io.determann.shadow.api.shadow.Class;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Generic;
import io.determann.shadow.api.shadow.Primitive;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.property.ImmutablePropertyImpl;
import io.determann.shadow.impl.property.MutablePropertyImpl;
import io.determann.shadow.impl.property.PropertyImpl;
import io.determann.shadow.impl.shadow.DeclaredImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ClassImpl
extends DeclaredImpl
implements Class {
    public ClassImpl(ShadowApi shadowApi, DeclaredType declaredTypeMirror) {
        super(shadowApi, declaredTypeMirror);
    }

    public ClassImpl(ShadowApi shadowApi, TypeElement typeElement) {
        super(shadowApi, typeElement);
    }

    @Override
    public boolean isAssignableFrom(Shadow<? extends TypeMirror> shadow) {
        return this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().isAssignable((TypeMirror)this.getMirror(), shadow.getMirror());
    }

    @Override
    public Class getSuperClass() {
        TypeMirror superclass = this.getElement().getSuperclass();
        if (TypeKind.NONE.equals((Object)superclass.getKind())) {
            return null;
        }
        return (Class)this.getApi().getShadowFactory().shadowFromType(superclass);
    }

    @Override
    public List<Class> getPermittedSubClasses() {
        return this.getElement().getPermittedSubclasses().stream().map(typeMirror -> (Class)this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror)).toList();
    }

    @Override
    public List<Property> getProperties() {
        return PropertyImpl.of(this);
    }

    @Override
    public List<MutableProperty> getMutableProperties() {
        return MutablePropertyImpl.of(this);
    }

    @Override
    public List<ImmutableProperty> getImmutableProperties() {
        return ImmutablePropertyImpl.of(this);
    }

    @Override
    public Optional<Declared> getOuterType() {
        TypeMirror enclosingType = ((DeclaredType)this.getMirror()).getEnclosingType();
        if (enclosingType.getKind().equals((Object)TypeKind.NONE)) {
            return Optional.empty();
        }
        return Optional.of((Declared)this.getApi().getShadowFactory().shadowFromType(enclosingType));
    }

    @Override
    @SafeVarargs
    public final Class withGenerics(Shadow<? extends TypeMirror> ... generics) {
        if (generics.length == 0 || this.getFormalGenerics().size() != generics.length) {
            throw new IllegalArgumentException(this.getQualifiedName() + " has " + this.getFormalGenerics().size() + " generics. " + generics.length + " are provided");
        }
        if (this.getOuterType().flatMap(typeMirrorShadow -> ShadowApi.convert(typeMirrorShadow).toInterface().map(anInterface -> !anInterface.getFormalGenerics().isEmpty()).or(() -> ShadowApi.convert(typeMirrorShadow).toClass().map(aClass -> !aClass.getGenerics().isEmpty()))).orElse(false).booleanValue()) {
            throw new IllegalArgumentException("cant add generics to " + this.getQualifiedName() + " when the class is not static and the outer class has generics");
        }
        TypeMirror[] typeMirrors = (TypeMirror[])Arrays.stream(generics).map(Shadow::getMirror).toArray(TypeMirror[]::new);
        return (Class)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().getDeclaredType(this.getElement(), typeMirrors));
    }

    @Override
    public Class withGenerics(String ... qualifiedGenerics) {
        return this.withGenerics((Shadow[])Arrays.stream(qualifiedGenerics).map(qualifiedName -> this.getApi().getDeclaredOrThrow((String)qualifiedName)).toArray(Shadow[]::new));
    }

    @Override
    public List<Shadow<TypeMirror>> getGenerics() {
        return ((DeclaredType)this.getMirror()).getTypeArguments().stream().map(typeMirror -> this.getApi().getShadowFactory().shadowFromType((TypeMirror)typeMirror)).toList();
    }

    @Override
    public List<Generic> getFormalGenerics() {
        return this.getElement().getTypeParameters().stream().map(element -> (Generic)this.getApi().getShadowFactory().shadowFromElement((Element)element)).toList();
    }

    @Override
    public Class interpolateGenerics() {
        return (Class)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().capture((TypeMirror)this.getMirror()));
    }

    @Override
    public Class erasure() {
        return (Class)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().erasure((TypeMirror)this.getMirror()));
    }

    @Override
    public Primitive asUnboxed() {
        return (Primitive)this.getApi().getShadowFactory().shadowFromType(this.getApi().getJdkApiContext().getProcessingEnv().getTypeUtils().unboxedType((TypeMirror)this.getMirror()));
    }
}

