/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.property;

import io.determann.shadow.api.ElementBacked;
import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Class;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Parameter;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.property.PropertyTemplate;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;

class PropertyTemplateFactory {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";

    private PropertyTemplateFactory() {
    }

    static List<PropertyTemplate> templatesFor(Declared declared) {
        Map nameField = declared.getFields().stream().collect(Collectors.toMap(ElementBacked::getSimpleName, Function.identity()));
        AtomicInteger position = new AtomicInteger();
        Map<String, Map<AccessorType, List<Accessor>>> nameTypeAccessors = PropertyTemplateFactory.getMethods(declared).stream().filter(method -> !method.isStatic()).map(method1 -> PropertyTemplateFactory.toAccessor(method1, position.getAndIncrement())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(Accessor::name, Collectors.groupingBy(Accessor::type)));
        return nameTypeAccessors.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey((Object)AccessorType.GETTER)).map(entry -> {
            Accessor getter = PropertyTemplateFactory.findGetter((Map)entry.getValue());
            String name = (String)entry.getKey();
            Shadow<TypeMirror> type = getter.method().getReturnType();
            PropertyTemplate template = new PropertyTemplate(name, type, getter.method());
            PropertyTemplateFactory.findSetter((Map)entry.getValue(), type).ifPresent(template::setSetter);
            PropertyTemplateFactory.findField(nameField, type, name).ifPresent(template::setField);
            return new AbstractMap.SimpleEntry<Integer, PropertyTemplate>(getter.position(), template);
        }).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).toList();
    }

    private static List<Method> getMethods(Declared declared) {
        if (!declared.isTypeKind(TypeKind.CLASS)) {
            return declared.getMethods();
        }
        List superClasses = Stream.iterate(ShadowApi.convert(declared).toClassOrThrow(), Objects::nonNull, Class::getSuperClass).collect(Collectors.toList());
        Collections.reverse(superClasses);
        List methods = superClasses.stream().flatMap(aClass -> aClass.getMethods().stream()).toList();
        return methods.stream().filter(method -> methods.stream().noneMatch(method::overwrittenBy)).toList();
    }

    private static Optional<Field> findField(Map<String, Field> nameField, Shadow<TypeMirror> type, String name) {
        Field field = nameField.get(name);
        if (field == null || !field.getType().representsSameType(type)) {
            return Optional.empty();
        }
        return Optional.of(field);
    }

    private static Optional<Method> findSetter(Map<AccessorType, List<Accessor>> typeAccessors, Shadow<TypeMirror> type) {
        List<Accessor> setters = typeAccessors.get((Object)AccessorType.SETTER);
        if (setters == null || setters.size() != 1 || !setters.get(0).method().getParameters().get(0).getType().representsSameType(type)) {
            return Optional.empty();
        }
        return Optional.of(setters.get(0).method());
    }

    private static Accessor findGetter(Map<AccessorType, List<Accessor>> typeAccessors) {
        List<Accessor> getters = typeAccessors.get((Object)AccessorType.GETTER);
        if (getters == null || getters.size() > 2) {
            throw new IllegalStateException();
        }
        if (getters.size() == 1) {
            return getters.get(0);
        }
        if (getters.size() == 2) {
            for (Accessor accessor : getters) {
                if (!accessor.prefix().equals(IS_PREFIX)) continue;
                return accessor;
            }
        }
        throw new IllegalStateException();
    }

    private static Optional<Accessor> toAccessor(Method method, int position) {
        boolean couldBeSetter;
        String name = method.getSimpleName();
        List<Parameter> parameters = method.getParameters();
        if (!method.getReturnType().isTypeKind(TypeKind.VOID)) {
            boolean hasIsPrefix;
            boolean hasGetPrefix = name.startsWith(GET_PREFIX) && name.length() > 3;
            boolean bl = hasIsPrefix = method.getReturnType().isTypeKind(TypeKind.BOOLEAN) && name.startsWith(IS_PREFIX) && name.length() > 2;
            if (parameters.isEmpty()) {
                if (hasGetPrefix) {
                    return Optional.of(new Accessor(method, AccessorType.GETTER, GET_PREFIX, PropertyTemplateFactory.toPropertyName(method, GET_PREFIX), position));
                }
                if (hasIsPrefix) {
                    return Optional.of(new Accessor(method, AccessorType.GETTER, IS_PREFIX, PropertyTemplateFactory.toPropertyName(method, IS_PREFIX), position));
                }
            }
            return Optional.empty();
        }
        boolean bl = couldBeSetter = method.getReturnType().isTypeKind(TypeKind.VOID) && name.startsWith(SET_PREFIX) && name.length() > 3;
        if (couldBeSetter && parameters.size() == 1) {
            return Optional.of(new Accessor(method, AccessorType.SETTER, SET_PREFIX, PropertyTemplateFactory.toPropertyName(method, SET_PREFIX), position));
        }
        return Optional.empty();
    }

    private static String toPropertyName(Method method, String prefix) {
        String name = method.getSimpleName().substring(prefix.length());
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static enum AccessorType {
        GETTER,
        SETTER;

    }

    private record Accessor(Method method, AccessorType type, String prefix, String name, int position) {
    }
}

