/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.property;

import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Shadow;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;

class PropertyTemplate {
    private final String name;
    private final Shadow<TypeMirror> type;
    private Method setter;
    private final Method getter;
    private Field field;

    PropertyTemplate(String name, Shadow<TypeMirror> type, Method getter) {
        this.name = name;
        this.type = type;
        this.getter = getter;
    }

    String getName() {
        return this.name;
    }

    Shadow<TypeMirror> getType() {
        return this.type;
    }

    Method getSetter() {
        return this.setter;
    }

    void setSetter(Method setter) {
        this.setter = setter;
    }

    Method getGetter() {
        return this.getter;
    }

    Field getField() {
        return this.field;
    }

    void setField(Field field) {
        this.field = field;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PropertyTemplate)) return false;
        PropertyTemplate that = (PropertyTemplate)o;
        if (!Objects.equals(this.setter, that.setter)) return false;
        if (!Objects.equals(this.getter, that.getter)) return false;
        if (!Objects.equals(this.field, that.field)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.setter, this.getter, this.field);
    }

    public String toString() {
        return "PropertyTemplate{name='" + this.name + "', type=" + this.type + ", setter=" + this.setter + ", getter=" + this.getter + ", field=" + this.field + "}";
    }
}

