/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.property;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.property.Property;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.property.PropertyTemplateFactory;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public class PropertyImpl
implements Property {
    private final String name;
    private final Shadow<TypeMirror> type;
    private final ShadowApi shadowApi;
    private final Field field;
    private final Method getter;
    private final Method setter;

    public static List<Property> of(Declared declared) {
        return PropertyTemplateFactory.templatesFor(declared).stream().map(template -> new PropertyImpl(declared.getApi(), template.getName(), template.getType(), template.getField(), template.getGetter(), template.getSetter())).map(Property.class::cast).toList();
    }

    private PropertyImpl(ShadowApi shadowApi, String name, Shadow<TypeMirror> type, Field field, Method getter, Method setter) {
        this.shadowApi = shadowApi;
        this.name = name;
        this.type = type;
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public ShadowApi getApi() {
        return this.shadowApi;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public Shadow<TypeMirror> getType() {
        return this.type;
    }

    @Override
    public Optional<Field> getField() {
        return Optional.ofNullable(this.field);
    }

    @Override
    public Field getFieldOrThrow() {
        return this.getField().orElseThrow();
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }

    @Override
    public Method getSetterOrThrow() {
        return this.getSetter().orElseThrow();
    }

    @Override
    public Optional<Method> getSetter() {
        return Optional.ofNullable(this.setter);
    }

    @Override
    public boolean isMutable() {
        return this.getSetter().isPresent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PropertyImpl)) return false;
        PropertyImpl property = (PropertyImpl)o;
        if (!Objects.equals(this.field, property.field)) return false;
        if (!Objects.equals(this.getter, property.getter)) return false;
        if (!Objects.equals(this.setter, property.setter)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.getter, this.setter);
    }

    public String toString() {
        return "PropertyImpl{field=" + this.field + ", getter=" + this.getter + ", setter=" + this.setter + "}";
    }
}

