/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.property;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.property.MutableProperty;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.property.PropertyTemplateFactory;
import java.util.List;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public class MutablePropertyImpl
implements MutableProperty {
    private final ShadowApi api;
    private final String name;
    private final Shadow<TypeMirror> type;
    private final Field field;
    private final Method getter;
    private final Method setter;

    public static List<MutableProperty> of(Declared declared) {
        return PropertyTemplateFactory.templatesFor(declared).stream().filter(template -> template.getSetter() != null).map(template -> new MutablePropertyImpl(declared.getApi(), template.getName(), template.getType(), template.getField(), template.getGetter(), template.getSetter())).map(MutableProperty.class::cast).toList();
    }

    private MutablePropertyImpl(ShadowApi api, String name, Shadow<TypeMirror> type, Field field, Method getter, Method setter) {
        this.name = name;
        this.type = type;
        this.api = api;
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public ShadowApi getApi() {
        return this.api;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public Shadow<TypeMirror> getType() {
        return this.type;
    }

    @Override
    public Optional<Field> getField() {
        return Optional.ofNullable(this.field);
    }

    @Override
    public Field getFieldOrThrow() {
        return this.getField().orElseThrow();
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }

    @Override
    public Method getSetter() {
        return this.setter;
    }
}

