/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.property;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.property.ImmutableProperty;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.property.PropertyTemplateFactory;
import java.util.List;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

public class ImmutablePropertyImpl
implements ImmutableProperty {
    private final ShadowApi api;
    private final String name;
    private final Shadow<TypeMirror> type;
    private final Field field;
    private final Method getter;

    public static List<ImmutableProperty> of(Declared declared) {
        return PropertyTemplateFactory.templatesFor(declared).stream().filter(template -> template.getSetter() == null).map(template -> new ImmutablePropertyImpl(declared.getApi(), template.getName(), template.getType(), template.getField(), template.getGetter())).map(ImmutableProperty.class::cast).toList();
    }

    private ImmutablePropertyImpl(ShadowApi api, String name, Shadow<TypeMirror> type, Field field, Method getter) {
        this.api = api;
        this.name = name;
        this.type = type;
        this.field = field;
        this.getter = getter;
    }

    @Override
    public ShadowApi getApi() {
        return this.api;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    @Override
    public Shadow<TypeMirror> getType() {
        return this.type;
    }

    @Override
    public Optional<Field> getField() {
        return Optional.ofNullable(this.field);
    }

    @Override
    public Field getFieldOrThrow() {
        return this.getField().orElseThrow();
    }

    @Override
    public Method getGetter() {
        return this.getter;
    }
}

