/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.converter;

import io.determann.shadow.api.converter.module.DirectiveConverter;
import io.determann.shadow.api.converter.module.ExportsConverter;
import io.determann.shadow.api.converter.module.OpensConverter;
import io.determann.shadow.api.converter.module.ProvidesConverter;
import io.determann.shadow.api.converter.module.RequiresConverter;
import io.determann.shadow.api.converter.module.UsesConverter;
import io.determann.shadow.api.shadow.module.Directive;
import io.determann.shadow.api.shadow.module.DirectiveKind;
import io.determann.shadow.api.shadow.module.Exports;
import io.determann.shadow.api.shadow.module.Opens;
import io.determann.shadow.api.shadow.module.Provides;
import io.determann.shadow.api.shadow.module.Requires;
import io.determann.shadow.api.shadow.module.Uses;
import java.util.Optional;

public class DirectiveConverterImpl
implements DirectiveConverter,
ExportsConverter,
OpensConverter,
ProvidesConverter,
RequiresConverter,
UsesConverter {
    private final Directive directive;

    public DirectiveConverterImpl(Directive directive) {
        this.directive = directive;
    }

    @Override
    public Exports toExportsOrThrow() {
        return (Exports)this.to(DirectiveKind.EXPORTS);
    }

    @Override
    public Optional<Exports> toExports() {
        return this.toOptional(DirectiveKind.EXPORTS);
    }

    @Override
    public Opens toOpensOrThrow() {
        return (Opens)this.to(DirectiveKind.OPENS);
    }

    @Override
    public Optional<Opens> toOpens() {
        return this.toOptional(DirectiveKind.OPENS);
    }

    @Override
    public Provides toProvidesOrThrow() {
        return (Provides)this.to(DirectiveKind.PROVIDES);
    }

    @Override
    public Optional<Provides> toProvides() {
        return this.toOptional(DirectiveKind.PROVIDES);
    }

    @Override
    public Requires toRequiresOrThrow() {
        return (Requires)this.to(DirectiveKind.REQUIRES);
    }

    @Override
    public Optional<Requires> toRequires() {
        return this.toOptional(DirectiveKind.REQUIRES);
    }

    @Override
    public Uses toUsesOrThrow() {
        return (Uses)this.to(DirectiveKind.USES);
    }

    @Override
    public Optional<Uses> toUses() {
        return this.toOptional(DirectiveKind.USES);
    }

    private <DIRECTIVE extends Directive> DIRECTIVE to(DirectiveKind directiveKind) {
        return (DIRECTIVE)((Directive)this.toOptional(directiveKind).orElseThrow(() -> new IllegalStateException(this.directive.getKind() + " is not a " + directiveKind)));
    }

    private <DIRECTIVE extends Directive> Optional<DIRECTIVE> toOptional(DirectiveKind directiveKind) {
        if (directiveKind.equals((Object)this.directive.getKind())) {
            return Optional.of(this.directive);
        }
        return Optional.empty();
    }
}

