/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl.converter;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.converter.AnnotationConverter;
import io.determann.shadow.api.converter.ArrayConverter;
import io.determann.shadow.api.converter.ClassConverter;
import io.determann.shadow.api.converter.ConstructorConverter;
import io.determann.shadow.api.converter.DeclaredConsumer;
import io.determann.shadow.api.converter.DeclaredConverter;
import io.determann.shadow.api.converter.DeclaredMapper;
import io.determann.shadow.api.converter.EnumConstantConverter;
import io.determann.shadow.api.converter.EnumConverter;
import io.determann.shadow.api.converter.ExecutableConsumer;
import io.determann.shadow.api.converter.ExecutableConverter;
import io.determann.shadow.api.converter.ExecutableMapper;
import io.determann.shadow.api.converter.FieldConverter;
import io.determann.shadow.api.converter.GenericConverter;
import io.determann.shadow.api.converter.InterfaceConverter;
import io.determann.shadow.api.converter.IntersectionConverter;
import io.determann.shadow.api.converter.MethodConverter;
import io.determann.shadow.api.converter.ModuleConverter;
import io.determann.shadow.api.converter.NullConverter;
import io.determann.shadow.api.converter.PackageConverter;
import io.determann.shadow.api.converter.ParameterConverter;
import io.determann.shadow.api.converter.PrimitiveConverter;
import io.determann.shadow.api.converter.RecordComponentConverter;
import io.determann.shadow.api.converter.RecordConverter;
import io.determann.shadow.api.converter.ShadowConverter;
import io.determann.shadow.api.converter.VariableConsumer;
import io.determann.shadow.api.converter.VariableConverter;
import io.determann.shadow.api.converter.VariableMapper;
import io.determann.shadow.api.converter.VoidConverter;
import io.determann.shadow.api.converter.WildcardConverter;
import io.determann.shadow.api.shadow.Annotation;
import io.determann.shadow.api.shadow.Array;
import io.determann.shadow.api.shadow.Class;
import io.determann.shadow.api.shadow.Constructor;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Enum;
import io.determann.shadow.api.shadow.EnumConstant;
import io.determann.shadow.api.shadow.Executable;
import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Generic;
import io.determann.shadow.api.shadow.Interface;
import io.determann.shadow.api.shadow.Intersection;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Module;
import io.determann.shadow.api.shadow.Null;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Parameter;
import io.determann.shadow.api.shadow.Primitive;
import io.determann.shadow.api.shadow.Record;
import io.determann.shadow.api.shadow.RecordComponent;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.api.shadow.Variable;
import io.determann.shadow.api.shadow.Void;
import io.determann.shadow.api.shadow.Wildcard;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.type.TypeMirror;

public class ConverterImpl
implements ShadowConverter,
AnnotationConverter,
ArrayConverter,
ClassConverter,
ConstructorConverter,
DeclaredConverter,
EnumConstantConverter,
EnumConverter,
ExecutableConverter,
FieldConverter,
InterfaceConverter,
IntersectionConverter,
MethodConverter,
ModuleConverter,
VoidConverter,
NullConverter,
PackageConverter,
ParameterConverter,
PrimitiveConverter,
RecordComponentConverter,
RecordConverter,
GenericConverter,
VariableConverter,
WildcardConverter {
    private final ShadowApi shadowApi;
    private final Shadow<? extends TypeMirror> shadow;

    public ConverterImpl(Shadow<? extends TypeMirror> shadow) {
        this.shadowApi = shadow.getApi();
        this.shadow = shadow;
    }

    @Override
    public Annotation toAnnotationOrThrow() {
        return (Annotation)this.to(TypeKind.ANNOTATION);
    }

    @Override
    public Optional<Annotation> toAnnotation() {
        return this.toOptional(TypeKind.ANNOTATION);
    }

    @Override
    public Array toArrayOrThrow() {
        return (Array)this.to(TypeKind.ARRAY);
    }

    @Override
    public Optional<Array> toArray() {
        return this.toOptional(TypeKind.ARRAY);
    }

    @Override
    public Class toClassOrThrow() {
        return (Class)this.to(TypeKind.CLASS);
    }

    @Override
    public Optional<Class> toClass() {
        return this.toOptional(TypeKind.CLASS);
    }

    @Override
    public Constructor toConstructorOrThrow() {
        return (Constructor)this.to(TypeKind.CONSTRUCTOR);
    }

    @Override
    public Optional<Constructor> toConstructor() {
        return this.toOptional(TypeKind.CONSTRUCTOR);
    }

    @Override
    public Declared toDeclaredOrThrow() {
        return (Declared)this.to(TypeKind::isDeclared);
    }

    @Override
    public Optional<Declared> toDeclared() {
        return this.toOptional(TypeKind::isDeclared);
    }

    @Override
    public EnumConstant toEnumConstantOrThrow() {
        return (EnumConstant)this.to(TypeKind.ENUM_CONSTANT);
    }

    @Override
    public Optional<EnumConstant> toEnumConstant() {
        return this.toOptional(TypeKind.ENUM_CONSTANT);
    }

    @Override
    public Enum toEnumOrThrow() {
        return (Enum)this.to(TypeKind.ENUM);
    }

    @Override
    public Optional<Enum> toEnum() {
        return this.toOptional(TypeKind.ENUM);
    }

    @Override
    public Executable toExecutableOrThrow() {
        return (Executable)this.to(TypeKind::isExecutable);
    }

    @Override
    public Optional<Executable> toExecutable() {
        return this.toOptional(TypeKind::isExecutable);
    }

    @Override
    public Field toFieldOrThrow() {
        return (Field)this.to(TypeKind.FIELD);
    }

    @Override
    public Optional<Field> toField() {
        return this.toOptional(TypeKind.FIELD);
    }

    @Override
    public Interface toInterfaceOrThrow() {
        return (Interface)this.to(TypeKind.INTERFACE);
    }

    @Override
    public Optional<Interface> toInterface() {
        return this.toOptional(TypeKind.INTERFACE);
    }

    @Override
    public Intersection toIntersectionOrThrow() {
        return (Intersection)this.to(TypeKind.INTERSECTION);
    }

    @Override
    public Optional<Intersection> toIntersection() {
        return this.toOptional(TypeKind.INTERSECTION);
    }

    @Override
    public Method toMethodOrThrow() {
        return (Method)this.to(TypeKind.METHOD);
    }

    @Override
    public Optional<Method> toMethod() {
        return this.toOptional(TypeKind.METHOD);
    }

    @Override
    public Module toModuleOrThrow() {
        return (Module)this.to(TypeKind.MODULE);
    }

    @Override
    public Optional<Module> toModule() {
        return this.toOptional(TypeKind.MODULE);
    }

    @Override
    public Void toVoidOrThrow() {
        return (Void)this.to(TypeKind.VOID);
    }

    @Override
    public Optional<Package> toPackage() {
        return this.toOptional(TypeKind.PACKAGE);
    }

    @Override
    public Parameter toParameterOrThrow() {
        return (Parameter)this.to(TypeKind.PARAMETER);
    }

    @Override
    public Optional<Parameter> toParameter() {
        return this.toOptional(TypeKind.PARAMETER);
    }

    @Override
    public Primitive toPrimitiveOrThrow() {
        return (Primitive)this.to(TypeKind::isPrimitive);
    }

    @Override
    public Optional<Void> toVoid() {
        return this.toOptional(TypeKind.VOID);
    }

    @Override
    public Null toNullOrThrow() {
        return (Null)this.to(TypeKind.NULL);
    }

    @Override
    public Optional<Null> toNull() {
        return this.toOptional(TypeKind.NULL);
    }

    @Override
    public Package toPackageOrThrow() {
        return (Package)this.to(TypeKind.PACKAGE);
    }

    @Override
    public Optional<Primitive> toPrimitive() {
        return this.toOptional(TypeKind::isPrimitive);
    }

    @Override
    public RecordComponent toRecordOrThrowComponentOrThrow() {
        return (RecordComponent)this.to(TypeKind.RECORD_COMPONENT);
    }

    @Override
    public Optional<RecordComponent> toRecordComponent() {
        return this.toOptional(TypeKind.RECORD_COMPONENT);
    }

    @Override
    public Record toRecordOrThrow() {
        return (Record)this.to(TypeKind.RECORD);
    }

    @Override
    public Optional<Record> toRecord() {
        return this.toOptional(TypeKind.RECORD);
    }

    @Override
    public Generic toGenericOrThrow() {
        return (Generic)this.to(TypeKind.GENERIC);
    }

    @Override
    public Optional<Generic> toGeneric() {
        return this.toOptional(TypeKind.GENERIC);
    }

    @Override
    public Variable<Shadow<TypeMirror>> toVariableOrThrow() {
        return (Variable)this.to(TypeKind::isVariable);
    }

    @Override
    public Optional<Variable<Shadow<TypeMirror>>> toVariable() {
        return this.toOptional(TypeKind::isVariable);
    }

    @Override
    public Wildcard toWildcardOrThrow() {
        return (Wildcard)this.to(TypeKind.WILDCARD);
    }

    private <MIRROR extends TypeMirror, SHADOW extends Shadow<MIRROR>> SHADOW to(TypeKind typeKind) {
        return (SHADOW)((Shadow)this.toOptional(typeKind).orElseThrow(() -> new IllegalStateException(this.shadow.getTypeKind() + " is not a " + typeKind)));
    }

    private <MIRROR extends TypeMirror, SHADOW extends Shadow<MIRROR>> SHADOW to(Predicate<TypeKind> typeKindPredicate) {
        List<TypeKind> typeKinds = Arrays.stream(TypeKind.values()).filter(typeKindPredicate).toList();
        return (SHADOW)((Shadow)this.toOptional(typeKindPredicate).orElseThrow(() -> new IllegalStateException(this.shadow.getTypeKind() + " is none of " + typeKinds)));
    }

    private <MIRROR extends TypeMirror, SHADOW extends Shadow<MIRROR>> Optional<SHADOW> toOptional(TypeKind typeKind) {
        return this.toOptional((TypeKind typeKind1) -> typeKind1.equals((Object)typeKind));
    }

    private <MIRROR extends TypeMirror, SHADOW extends Shadow<MIRROR>> Optional<SHADOW> toOptional(Predicate<TypeKind> typeKindPredicate) {
        if (typeKindPredicate.test(this.shadow.getTypeKind())) {
            return Optional.of(this.shadow);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Wildcard> toWildcard() {
        if (this.shadow.getTypeKind().equals((Object)TypeKind.WILDCARD)) {
            return Optional.of((Wildcard)this.shadow);
        }
        return Optional.empty();
    }

    @Override
    public void consume(DeclaredConsumer consumer) {
        this.toClass().ifPresent(consumer::classType);
        this.toInterface().ifPresent(consumer::interfaceType);
        this.toEnum().ifPresent(consumer::enumType);
        this.toAnnotation().ifPresent(consumer::annotationType);
        this.toRecord().ifPresent(consumer::recordType);
    }

    @Override
    public <T> T map(DeclaredMapper<T> mapper) {
        return this.toClass().map(mapper::classType).orElse(this.toInterface().map(mapper::interfaceType).orElse(this.toEnum().map(mapper::enumType).orElse(this.toAnnotation().map(mapper::annotationType).orElse(this.toRecord().map(mapper::recordType).orElse(null)))));
    }

    @Override
    public void consume(ExecutableConsumer consumer) {
        this.toMethod().ifPresent(consumer::method);
        this.toConstructor().ifPresent(consumer::constructor);
    }

    @Override
    public <T> T map(ExecutableMapper<T> mapper) {
        return this.toMethod().map(mapper::method).orElse(this.toConstructor().map(mapper::constructor).orElse(null));
    }

    @Override
    public void consume(VariableConsumer consumer) {
        this.toEnumConstant().ifPresent(consumer::enumConstant);
        this.toField().ifPresent(consumer::field);
        this.toParameter().ifPresent(consumer::parameter);
    }

    @Override
    public <T> T map(VariableMapper<T> mapper) {
        return this.toEnumConstant().map(mapper::enumConstant).orElse(this.toField().map(mapper::field).orElse(this.toParameter().map(mapper::parameter).orElse(null)));
    }
}

