/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl;

import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.ShadowFactory;
import io.determann.shadow.api.shadow.AnnotationUsage;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.impl.shadow.ArrayImpl;
import io.determann.shadow.impl.shadow.ClassImpl;
import io.determann.shadow.impl.shadow.DeclaredImpl;
import io.determann.shadow.impl.shadow.EnumConstantImpl;
import io.determann.shadow.impl.shadow.ExecutableImpl;
import io.determann.shadow.impl.shadow.FieldImpl;
import io.determann.shadow.impl.shadow.GenericImpl;
import io.determann.shadow.impl.shadow.InterfaceImpl;
import io.determann.shadow.impl.shadow.IntersectionImpl;
import io.determann.shadow.impl.shadow.ModuleImpl;
import io.determann.shadow.impl.shadow.NullImpl;
import io.determann.shadow.impl.shadow.PackageImpl;
import io.determann.shadow.impl.shadow.ParameterImpl;
import io.determann.shadow.impl.shadow.PrimitiveImpl;
import io.determann.shadow.impl.shadow.RecordComponentImpl;
import io.determann.shadow.impl.shadow.RecordImpl;
import io.determann.shadow.impl.shadow.VoidImpl;
import io.determann.shadow.impl.shadow.WildcardImpl;
import io.determann.shadow.impl.shadow.wraper.AnnotationUsageImpl;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

class ShadowFactoryImpl
implements ShadowFactory {
    private final ShadowApi shadowApi;

    ShadowFactoryImpl(ShadowApi shadowApi) {
        this.shadowApi = shadowApi;
    }

    @Override
    public <SHADOW extends Shadow<? extends TypeMirror>> SHADOW shadowFromElement(Element element) {
        return (SHADOW)(switch (element.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case ElementKind.PACKAGE -> new PackageImpl(this.shadowApi, (PackageElement)element);
            case ElementKind.ENUM, ElementKind.ANNOTATION_TYPE -> new DeclaredImpl(this.shadowApi, (TypeElement)element);
            case ElementKind.RECORD -> new RecordImpl(this.shadowApi, (TypeElement)element);
            case ElementKind.CLASS -> new ClassImpl(this.shadowApi, (TypeElement)element);
            case ElementKind.INTERFACE -> new InterfaceImpl(this.shadowApi, (TypeElement)element);
            case ElementKind.METHOD, ElementKind.CONSTRUCTOR -> new ExecutableImpl(this.shadowApi, (ExecutableElement)element);
            case ElementKind.ENUM_CONSTANT -> new EnumConstantImpl(this.shadowApi, (VariableElement)element);
            case ElementKind.FIELD -> new FieldImpl(this.shadowApi, (VariableElement)element);
            case ElementKind.PARAMETER -> new ParameterImpl(this.shadowApi, (VariableElement)element);
            case ElementKind.TYPE_PARAMETER -> new GenericImpl(this.shadowApi, (TypeParameterElement)element);
            case ElementKind.MODULE -> new ModuleImpl(this.shadowApi, (ModuleElement)element);
            case ElementKind.RECORD_COMPONENT -> new RecordComponentImpl(this.shadowApi, (RecordComponentElement)element);
            case ElementKind.OTHER, ElementKind.STATIC_INIT, ElementKind.INSTANCE_INIT, ElementKind.EXCEPTION_PARAMETER, ElementKind.RESOURCE_VARIABLE, ElementKind.BINDING_VARIABLE, ElementKind.LOCAL_VARIABLE -> throw new IllegalArgumentException("not implemented");
        });
    }

    @Override
    public <SHADOW extends Shadow<? extends TypeMirror>> SHADOW shadowFromType(TypeMirror typeMirror) {
        return (SHADOW)(switch (typeMirror.getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.SHORT, TypeKind.INT, TypeKind.LONG, TypeKind.CHAR, TypeKind.FLOAT, TypeKind.DOUBLE -> new PrimitiveImpl(this.shadowApi, (PrimitiveType)typeMirror);
            case TypeKind.ARRAY -> new ArrayImpl(this.shadowApi, (ArrayType)typeMirror);
            case TypeKind.DECLARED -> {
                switch (this.shadowApi.getJdkApiContext().getProcessingEnv().getTypeUtils().asElement(typeMirror).getKind()) {
                    case CLASS: {
                        yield new ClassImpl(this.shadowApi, (DeclaredType)typeMirror);
                    }
                    case INTERFACE: {
                        yield new InterfaceImpl(this.shadowApi, (DeclaredType)typeMirror);
                    }
                    case RECORD: {
                        yield new RecordImpl(this.shadowApi, (DeclaredType)typeMirror);
                    }
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        yield new DeclaredImpl(this.shadowApi, (DeclaredType)typeMirror);
                    }
                }
                throw new IllegalArgumentException("not implemented");
            }
            case TypeKind.WILDCARD -> new WildcardImpl(this.shadowApi, (WildcardType)typeMirror);
            case TypeKind.VOID -> new VoidImpl(this.shadowApi, (NoType)typeMirror);
            case TypeKind.PACKAGE -> new PackageImpl(this.shadowApi, (NoType)typeMirror);
            case TypeKind.MODULE -> new ModuleImpl(this.shadowApi, (NoType)typeMirror);
            case TypeKind.NULL -> new NullImpl(this.shadowApi, (NullType)typeMirror);
            case TypeKind.TYPEVAR -> new GenericImpl(this.shadowApi, (TypeVariable)typeMirror);
            case TypeKind.INTERSECTION -> new IntersectionImpl(this.shadowApi, (IntersectionType)typeMirror);
            case TypeKind.EXECUTABLE, TypeKind.NONE -> throw new IllegalArgumentException("bug in this api: executables should be created using elements");
            case TypeKind.ERROR, TypeKind.OTHER, TypeKind.UNION -> throw new IllegalArgumentException("not implemented");
        });
    }

    @Override
    public List<AnnotationUsage> annotationUsages(List<? extends AnnotationMirror> annotationMirrors) {
        return AnnotationUsageImpl.from(this.shadowApi, annotationMirrors);
    }
}

