/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl;

import io.determann.shadow.api.AnnotationTypeChooser;
import io.determann.shadow.api.DiagnosticContext;
import io.determann.shadow.api.ElementBacked;
import io.determann.shadow.api.JdkApiContext;
import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.ShadowConstants;
import io.determann.shadow.api.ShadowFactory;
import io.determann.shadow.api.converter.DeclaredMapper;
import io.determann.shadow.api.shadow.Annotation;
import io.determann.shadow.api.shadow.Class;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Enum;
import io.determann.shadow.api.shadow.Interface;
import io.determann.shadow.api.shadow.Module;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Record;
import io.determann.shadow.impl.AnnotationTypeChooserImpl;
import io.determann.shadow.impl.ShadowConstantsImpl;
import io.determann.shadow.impl.ShadowFactoryImpl;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class ShadowApiImpl
implements ShadowApi {
    private final JdkApiContext jdkApiContext;
    private final ShadowFactory shadowFactory = new ShadowFactoryImpl(this);
    private final int processingRound;
    private BiConsumer<ShadowApi, Throwable> exceptionHandler = (shadowApi, throwable) -> {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        shadowApi.logError(stringWriter.toString());
        throw new RuntimeException((Throwable)throwable);
    };
    private BiConsumer<ShadowApi, DiagnosticContext> diagnosticHandler = (shadowApi, diagnosticContext) -> {
        if (!shadowApi.isProcessingOver()) {
            String duration = Duration.between(diagnosticContext.getStart(), diagnosticContext.getEnd()).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
            shadowApi.logInfo(diagnosticContext.getProcessorName() + " took " + duration + " in round " + diagnosticContext.getProcessingRound() + "\n");
        }
    };
    private BiConsumer<ShadowApi, String> systemOutHandler = (shadowApi, s) -> {
        if (!shadowApi.getJdkApiContext().getProcessingEnv().toString().startsWith("javac")) {
            shadowApi.logWarning((String)s);
        }
    };
    private BiConsumer<ShadowApi, String> systemErrorHandler = ShadowApi::logError;

    public ShadowApiImpl(ProcessingEnvironment processingEnv, RoundEnvironment roundEnv, int processingRound) {
        this.processingRound = processingRound;
        this.jdkApiContext = new JdkApiContext(processingEnv, roundEnv);
        this.proxySystemOut();
        this.proxySystemErr();
    }

    @Override
    public JdkApiContext getJdkApiContext() {
        return this.jdkApiContext;
    }

    private void proxySystemOut() {
        PrintStream printStream = new PrintStream(System.out){

            @Override
            public void println(String x) {
                super.println(x);
                if (x != null && ShadowApiImpl.this.systemOutHandler != null) {
                    ShadowApiImpl.this.systemOutHandler.accept(ShadowApiImpl.this, x);
                }
            }
        };
        System.setOut(printStream);
    }

    private void proxySystemErr() {
        PrintStream printStream = new PrintStream(System.err){

            @Override
            public void println(String x) {
                super.println(x);
                if (x != null && ShadowApiImpl.this.systemErrorHandler != null) {
                    ShadowApiImpl.this.systemErrorHandler.accept(ShadowApiImpl.this, x);
                }
            }
        };
        System.setErr(printStream);
    }

    @Override
    public AnnotationTypeChooser getAnnotatedWith(String qualifiedAnnotation) {
        TypeElement annotation = this.getJdkApiContext().getProcessingEnv().getElementUtils().getTypeElement(qualifiedAnnotation);
        if (annotation == null || !annotation.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) {
            throw new IllegalArgumentException("No annotation found with qualified name \"" + qualifiedAnnotation + "\"");
        }
        return new AnnotationTypeChooserImpl(this, this.jdkApiContext.getRoundEnv().getElementsAnnotatedWith(annotation));
    }

    @Override
    public AnnotationTypeChooser getAnnotatedWith(Annotation annotation) {
        return this.getAnnotatedWith(annotation.getQualifiedName());
    }

    @Override
    public List<Module> getModules() {
        return this.getJdkApiContext().getProcessingEnv().getElementUtils().getAllModuleElements().stream().map(moduleElement -> (Module)this.getShadowFactory().shadowFromElement((Element)moduleElement)).toList();
    }

    @Override
    public Module getModuleOrThrow(String name) {
        ModuleElement moduleElement = this.getJdkApiContext().getProcessingEnv().getElementUtils().getModuleElement(name);
        if (moduleElement == null) {
            throw new IllegalArgumentException("no module fond with name \"" + name + "\"");
        }
        return (Module)this.getShadowFactory().shadowFromElement(moduleElement);
    }

    @Override
    public List<Package> getPackagesOrThrow(String qualifiedName) {
        return this.getJdkApiContext().getProcessingEnv().getElementUtils().getAllPackageElements(qualifiedName).stream().map(packageElement -> (Package)this.getShadowFactory().shadowFromElement((Element)packageElement)).toList();
    }

    @Override
    public List<Package> getPackages() {
        return this.getJdkApiContext().getProcessingEnv().getElementUtils().getAllModuleElements().stream().flatMap(moduleElement -> moduleElement.getEnclosedElements().stream()).map(packageElement -> (Package)this.getShadowFactory().shadowFromElement((Element)packageElement)).toList();
    }

    @Override
    public Package getPackageOrThrow(String qualifiedModuleName, String qualifiedPackageName) {
        return (Package)this.getShadowFactory().shadowFromElement(this.getJdkApiContext().getProcessingEnv().getElementUtils().getPackageElement((ModuleElement)this.getModuleOrThrow(qualifiedModuleName).getElement(), qualifiedPackageName));
    }

    @Override
    public Package getPackageOrThrow(Module module, String qualifiedPackageName) {
        return (Package)this.getShadowFactory().shadowFromElement(this.getJdkApiContext().getProcessingEnv().getElementUtils().getPackageElement((ModuleElement)module.getElement(), qualifiedPackageName));
    }

    @Override
    public Declared getDeclaredOrThrow(String qualifiedName) {
        TypeElement typeElement = this.getJdkApiContext().getProcessingEnv().getElementUtils().getTypeElement(qualifiedName);
        if (typeElement == null) {
            throw new IllegalArgumentException("no Declared found for \"" + qualifiedName + "\"");
        }
        return (Declared)this.getShadowFactory().shadowFromElement(typeElement);
    }

    @Override
    public List<Declared> getDeclared() {
        return this.getPackages().stream().flatMap(packageShadow -> packageShadow.getContent().stream()).toList();
    }

    @Override
    public ShadowFactory getShadowFactory() {
        return this.shadowFactory;
    }

    @Override
    public ShadowConstants getConstants() {
        return new ShadowConstantsImpl(this);
    }

    @Override
    public void logError(String msg) {
        this.getJdkApiContext().getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }

    @Override
    public void logInfo(String msg) {
        this.getJdkApiContext().getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    @Override
    public void logWarning(String msg) {
        this.getJdkApiContext().getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, msg);
    }

    @Override
    public void logErrorAt(ElementBacked<?> elementBacked, String msg) {
        elementBacked.logError(msg);
    }

    @Override
    public void logInfoAt(ElementBacked<?> elementBacked, String msg) {
        elementBacked.logInfo(msg);
    }

    @Override
    public void logWarningAt(ElementBacked<?> elementBacked, String msg) {
        elementBacked.logWarning(msg);
    }

    @Override
    public void writeSourceFile(String qualifiedName, String content) {
        try (Writer writer = this.getJdkApiContext().getProcessingEnv().getFiler().createSourceFile(qualifiedName, new Element[0]).openWriter();){
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeClassFile(String qualifiedName, String content) {
        try (Writer writer = this.getJdkApiContext().getProcessingEnv().getFiler().createClassFile(qualifiedName, new Element[0]).openWriter();){
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeResource(StandardLocation location, String moduleAndPkg, String relativPath, String content) {
        try (Writer writer = this.getJdkApiContext().getProcessingEnv().getFiler().createResource(location, moduleAndPkg, relativPath, new Element[0]).openWriter();){
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FileObject readResource(StandardLocation location, String moduleAndPkg, String relativPath) throws IOException {
        return this.getJdkApiContext().getProcessingEnv().getFiler().getResource(location, moduleAndPkg, relativPath);
    }

    @Override
    public boolean isProcessingOver() {
        return this.getJdkApiContext().getRoundEnv().processingOver();
    }

    @Override
    public boolean isFirstRound() {
        return this.processingRound == 0;
    }

    @Override
    public int getProcessingRound() {
        return this.processingRound;
    }

    public static Declared erasure(Declared declared) {
        return ShadowApi.convert(declared).map(new DeclaredMapper<Declared>(){

            @Override
            public Declared annotationType(Annotation annotation) {
                return annotation;
            }

            @Override
            public Declared enumType(Enum aEnum) {
                return aEnum;
            }

            @Override
            public Declared classType(Class aClass) {
                return aClass.erasure();
            }

            @Override
            public Declared interfaceType(Interface aInterface) {
                return aInterface.erasure();
            }

            @Override
            public Declared recordType(Record aRecord) {
                return aRecord.erasure();
            }
        });
    }

    @Override
    public void setExceptionHandler(BiConsumer<ShadowApi, Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public BiConsumer<ShadowApi, Throwable> getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setDiagnosticHandler(BiConsumer<ShadowApi, DiagnosticContext> diagnosticHandler) {
        this.diagnosticHandler = diagnosticHandler;
    }

    @Override
    public BiConsumer<ShadowApi, DiagnosticContext> getDiagnosticHandler() {
        return this.diagnosticHandler;
    }

    @Override
    public void setSystemOutHandler(BiConsumer<ShadowApi, String> systemOutHandler) {
        this.systemOutHandler = systemOutHandler;
    }

    @Override
    public BiConsumer<ShadowApi, String> getSystemOutHandler() {
        return this.systemOutHandler;
    }

    @Override
    public void setSystemErrorHandler(BiConsumer<ShadowApi, String> systemErrorHandler) {
        this.systemErrorHandler = systemErrorHandler;
    }

    @Override
    public BiConsumer<ShadowApi, String> getSystemErrorHandler() {
        return this.systemErrorHandler;
    }

    @Override
    public ShadowApi getApi() {
        return this;
    }
}

