/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.impl;

import io.determann.shadow.api.AnnotationTypeChooser;
import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.shadow.Annotation;
import io.determann.shadow.api.shadow.Class;
import io.determann.shadow.api.shadow.Constructor;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Enum;
import io.determann.shadow.api.shadow.Field;
import io.determann.shadow.api.shadow.Generic;
import io.determann.shadow.api.shadow.Interface;
import io.determann.shadow.api.shadow.Method;
import io.determann.shadow.api.shadow.Module;
import io.determann.shadow.api.shadow.Package;
import io.determann.shadow.api.shadow.Parameter;
import io.determann.shadow.api.shadow.Record;
import io.determann.shadow.api.shadow.RecordComponent;
import io.determann.shadow.api.shadow.Shadow;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class AnnotationTypeChooserImpl
implements AnnotationTypeChooser {
    private final Set<Shadow<TypeMirror>> shadows;

    AnnotationTypeChooserImpl(ShadowApi shadowApi, Set<? extends Element> elements) {
        this.shadows = elements.stream().map(element -> shadowApi.getShadowFactory().shadowFromElement((Element)element)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<Shadow<TypeMirror>> all() {
        return new HashSet<Shadow<TypeMirror>>(this.shadows);
    }

    @Override
    public Set<Declared> declaredTypes() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toDeclared());
    }

    @Override
    public Set<Class> classes() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toClass());
    }

    @Override
    public Set<Enum> enums() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toEnum());
    }

    @Override
    public Set<Interface> interfaces() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toInterface());
    }

    @Override
    public Set<Record> records() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toRecord());
    }

    @Override
    public Set<Field> fields() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toField());
    }

    @Override
    public Set<Parameter> parameters() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toParameter());
    }

    @Override
    public Set<Method> methods() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toMethod());
    }

    @Override
    public Set<Constructor> constructors() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toConstructor());
    }

    @Override
    public Set<Annotation> annotations() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toAnnotation());
    }

    @Override
    public Set<Package> packages() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toPackage());
    }

    @Override
    public Set<Generic> generics() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toGeneric());
    }

    @Override
    public Set<Module> modules() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toModule());
    }

    @Override
    public Set<RecordComponent> recordComponents() {
        return this.findShadows(shadow -> ShadowApi.convert(shadow).toRecordComponent());
    }

    private <SHADOW> Set<SHADOW> findShadows(Function<? super Shadow<TypeMirror>, Optional<SHADOW>> mapper) {
        return this.shadows.stream().map(mapper).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toUnmodifiableSet());
    }
}

