/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.api;

import io.determann.shadow.api.DiagnosticContext;
import io.determann.shadow.api.ShadowApi;
import java.time.Instant;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

public abstract class ShadowProcessor
extends AbstractProcessor {
    private int processingRound = 0;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("*");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ShadowApi api;
        Instant start;
        block3: {
            start = Instant.now();
            api = ShadowApi.create(this.processingEnv, roundEnv, this.processingRound);
            try {
                this.process(api);
            }
            catch (Throwable t) {
                if (api.getExceptionHandler() == null) break block3;
                api.getExceptionHandler().accept(api, t);
            }
        }
        if (api.getDiagnosticHandler() != null) {
            String processorName = this.getClass().isAnonymousClass() ? "anonymousProcessor" : this.getClass().getSimpleName();
            api.getDiagnosticHandler().accept(api, new DiagnosticContext(api, processorName, this.processingRound, start, Instant.now()));
        }
        ++this.processingRound;
        return false;
    }

    public abstract void process(ShadowApi var1) throws Exception;
}

