/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.api;

import io.determann.shadow.api.ApiHolder;
import io.determann.shadow.api.modifier.Modifiable;
import io.determann.shadow.api.modifier.Modifier;
import io.determann.shadow.api.shadow.Module;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public interface ElementBacked<ELEMENT extends Element>
extends Modifiable,
ApiHolder {
    public ELEMENT getElement();

    @Override
    default public Set<Modifier> getModifiers() {
        return this.getElement().getModifiers().stream().map(Modifier::mapModifier).collect(Collectors.toUnmodifiableSet());
    }

    default public Module getModule() {
        return (Module)this.getApi().getShadowFactory().shadowFromElement(this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getModuleOf((Element)this.getElement()));
    }

    default public String getSimpleName() {
        return this.getElement().getSimpleName().toString();
    }

    default public String getJavaDoc() {
        return this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getDocComment((Element)this.getElement());
    }

    default public void logError(String msg) {
        this.getApi().getJdkApiContext().getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, msg, (Element)this.getElement());
    }

    default public void logInfo(String msg) {
        this.getApi().getJdkApiContext().getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.NOTE, msg, (Element)this.getElement());
    }

    default public void logWarning(String msg) {
        this.getApi().getJdkApiContext().getProcessingEnv().getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, msg, (Element)this.getElement());
    }
}

