/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.api;

import io.determann.shadow.api.ShadowApi;
import java.time.Instant;
import java.util.Objects;

public class DiagnosticContext {
    private final ShadowApi api;
    private final String processorName;
    private final int processingRound;
    private final Instant start;
    private final Instant end;

    DiagnosticContext(ShadowApi api, String processorName, int processingRound, Instant start, Instant end) {
        this.api = api;
        this.processorName = processorName;
        this.processingRound = processingRound;
        this.start = start;
        this.end = end;
    }

    public ShadowApi getApi() {
        return this.api;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public int getProcessingRound() {
        return this.processingRound;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiagnosticContext)) {
            return false;
        }
        DiagnosticContext context = (DiagnosticContext)o;
        return this.getProcessingRound() == context.getProcessingRound() && Objects.equals(this.getApi(), context.getApi()) && Objects.equals(this.getProcessorName(), context.getProcessorName()) && Objects.equals(this.getStart(), context.getStart()) && Objects.equals(this.getEnd(), context.getEnd());
    }

    public int hashCode() {
        return Objects.hash(this.getApi(), this.getProcessorName(), this.getProcessingRound(), this.getStart(), this.getEnd());
    }

    public String toString() {
        return "DiagnosticContext{api=" + this.api + ", processorName='" + this.processorName + "', processingRound=" + this.processingRound + ", start=" + this.start + ", now=" + this.end + "}";
    }
}

