/*
 * Decompiled with CFR 0.152.
 */
package io.determann.shadow.api;

import io.determann.shadow.api.ElementBacked;
import io.determann.shadow.api.shadow.Annotation;
import io.determann.shadow.api.shadow.AnnotationUsage;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;

public interface Annotationable<ELEMENT extends Element>
extends ElementBacked<ELEMENT> {
    default public List<AnnotationUsage> getAnnotationUsages() {
        return this.getApi().getShadowFactory().annotationUsages(this.getApi().getJdkApiContext().getProcessingEnv().getElementUtils().getAllAnnotationMirrors((Element)this.getElement()));
    }

    default public List<AnnotationUsage> getUsagesOf(Annotation annotation) {
        return this.getAnnotationUsages().stream().filter(usage -> usage.getAnnotation().equals(annotation)).toList();
    }

    default public Optional<AnnotationUsage> getUsageOf(Annotation annotation) {
        List<AnnotationUsage> usages = this.getUsagesOf(annotation);
        if (usages.isEmpty()) {
            return Optional.empty();
        }
        if (usages.size() == 1) {
            return Optional.of(usages.get(0));
        }
        throw new IllegalArgumentException();
    }

    default public AnnotationUsage getUsageOfOrThrow(Annotation annotation) {
        return this.getUsageOf(annotation).orElseThrow(IllegalArgumentException::new);
    }

    default public boolean isAnnotatedWith(Annotation annotation) {
        return this.getAnnotationUsages().stream().map(AnnotationUsage::getAnnotation).anyMatch(annotation1 -> annotation1.equals(annotation));
    }

    default public List<AnnotationUsage> getDirectAnnotationUsages() {
        return this.getApi().getShadowFactory().annotationUsages(this.getElement().getAnnotationMirrors());
    }

    default public List<AnnotationUsage> getDirectUsagesOf(Annotation annotation) {
        return this.getDirectAnnotationUsages().stream().filter(usage -> usage.getAnnotation().equals(annotation)).toList();
    }

    default public Optional<AnnotationUsage> getDirectUsageOf(Annotation annotation) {
        return this.getDirectAnnotationUsages().stream().filter(usage -> usage.getAnnotation().equals(annotation)).findAny();
    }

    default public AnnotationUsage getDirectUsageOfOrThrow(Annotation annotation) {
        return this.getDirectUsageOf(annotation).orElseThrow();
    }

    default public boolean isDirectlyAnnotatedWith(Annotation annotation) {
        return this.getDirectAnnotationUsages().stream().map(AnnotationUsage::getAnnotation).anyMatch(annotation1 -> annotation1.equals(annotation));
    }
}

