/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.tutorial.lib;

import io.github.jamalam360.tutorial.lib.stage.Stage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1156;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class Tutorial {
    private final Stage[] stages;
    private int stage = 0;

    public Tutorial(Stage ... stages) {
        this.stages = stages;
    }

    @Nullable
    public Stage getCurrentStage() {
        if (this.stage < 0 || this.stage >= this.stages.length) {
            return null;
        }
        return this.stages[this.stage];
    }

    public int getCurrentStageIndex() {
        return this.stage;
    }

    @ApiStatus.Internal
    public void setCurrentStageIndex(int index) {
        this.stage = index;
    }

    public void advanceStage() {
        this.getCurrentStage().onFinish(this.getTutorialManager());
        this.setCurrentStageIndex(this.getCurrentStageIndex() + 1);
        this.saveGameOptions();
        if (this.getCurrentStageIndex() < this.stages.length) {
            this.getCurrentStage().onStart(this.getTutorialManager());
        }
    }

    public void setStageProgress(float progress) {
        this.getCurrentStage().getToast().method_1992(progress);
    }

    private class_1156 getTutorialManager() {
        return class_310.method_1551().method_1577();
    }

    private void saveGameOptions() {
        class_310.method_1551().field_1690.method_1640();
    }
}

