/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.tutorial.lib;

import io.github.jamalam360.tutorial.lib.ToastDuck;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_372;
import net.minecraft.class_374;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CustomTutorialToast
extends class_372
implements ToastDuck {
    private static final int TEXT_LEFT_MARGIN = 30;
    private static final int TEXT_RIGHT_MARGIN = 10;
    private final class_2561 title;
    @Nullable
    private final class_2561 description;
    private final boolean hasProgressBar;
    private final class_2960 texture;
    private final int u;
    private final int v;
    @Nullable
    private List<class_5481> wrappedTitle = null;
    @Nullable
    private List<class_5481> wrappedDescription = null;
    private class_368.class_369 visibility = class_368.class_369.field_2210;
    private long lastTime;
    private float lastProgress;
    private float progress;

    public CustomTutorialToast(class_2960 texture, class_2561 title) {
        this(texture, title, null);
    }

    public CustomTutorialToast(class_2960 texture, int u, int v, class_2561 title) {
        this(texture, u, v, title, null);
    }

    public CustomTutorialToast(class_2960 texture, class_2561 title, @Nullable class_2561 description) {
        this(texture, title, description, false);
    }

    public CustomTutorialToast(class_2960 texture, int u, int v, class_2561 title, @Nullable class_2561 description) {
        this(texture, u, v, title, description, false);
    }

    public CustomTutorialToast(class_2960 texture, class_2561 title, @Nullable class_2561 description, boolean hasProgressBar) {
        this(texture, 0, 0, title, description, hasProgressBar);
    }

    public CustomTutorialToast(class_2960 texture, int u, int v, class_2561 title, @Nullable class_2561 description, boolean hasProgressBar) {
        super(class_372.class_373.field_2237, title, description, hasProgressBar);
        this.title = title;
        this.description = description;
        this.hasProgressBar = hasProgressBar;
        this.texture = texture;
        this.u = u;
        this.v = v;
    }

    public class_368.class_369 method_1986(class_332 graphics, class_374 manager, long startTime) {
        int i;
        if (this.wrappedTitle == null) {
            this.wrappedTitle = class_310.method_1551().field_1772.method_1728((class_5348)this.title, 120);
        }
        if (this.wrappedDescription == null) {
            List<Object> list = this.wrappedDescription = this.description == null ? List.of() : class_310.method_1551().field_1772.method_1728((class_5348)this.description, 120);
        }
        if (this.wrappedTitle.size() == 1 && this.wrappedDescription.size() <= 1) {
            graphics.method_25302(field_2207, 0, 0, 0, 32, 160, 32);
        } else {
            int height = this.method_29050();
            int m = Math.min(4, height - 28);
            this.renderBackgroundRow(graphics, manager, 0, 0, 28);
            for (int n = 28; n < height - m; n += 10) {
                this.renderBackgroundRow(graphics, manager, 16, n, Math.min(16, height - n - m));
            }
            this.renderBackgroundRow(graphics, manager, 32 - m, height - m, m);
        }
        for (i = 0; i < this.wrappedTitle.size(); ++i) {
            graphics.method_51430(manager.method_1995().field_1772, this.wrappedTitle.get(i), 30, 7 + i * 12, -11534256, false);
        }
        for (i = 0; i < this.wrappedDescription.size(); ++i) {
            graphics.method_51430(manager.method_1995().field_1772, this.wrappedDescription.get(i), 30, 8 + this.wrappedTitle.size() * 12 + i * 12, -16777216, false);
        }
        graphics.method_25302(this.texture, 6, 6, this.u, this.v, 20, 20);
        if (this.hasProgressBar) {
            graphics.method_25294(3, 28 + (this.method_29050() - 32), 157, 29 + (this.method_29050() - 32), -1);
            float f = class_3532.method_37166((float)this.lastProgress, (float)this.progress, (float)((float)(startTime - this.lastTime) / 100.0f));
            int i2 = this.progress >= this.lastProgress ? -16755456 : -11206656;
            graphics.method_25294(3, 28 + (this.method_29050() - 32), (int)(3.0f + 154.0f * f), 29 + (this.method_29050() - 32), i2);
            this.lastProgress = f;
            this.lastTime = startTime;
        }
        return this.visibility;
    }

    private void renderBackgroundRow(class_332 graphics, class_374 manager, int vOffset, int y, int vHeight) {
        int uWidth = vOffset == 0 ? 20 : 5;
        graphics.method_25302(field_2207, 0, y, 0, 32 + vOffset, uWidth, vHeight);
        for (int o = uWidth; o < 100; o += 64) {
            graphics.method_25302(field_2207, o, y, 32, 32 + vOffset, Math.min(64, 160 - o - 60), vHeight);
        }
        graphics.method_25302(field_2207, 100, y, 100, 32 + vOffset, 60, vHeight);
    }

    public int method_29050() {
        return 10 + (this.wrappedTitle == null ? 0 : this.wrappedTitle.size() * 12) + (this.wrappedDescription == null ? 0 : this.wrappedDescription.size() * 12);
    }

    public void show() {
        this.visibility = class_368.class_369.field_2210;
    }

    public void method_1993() {
        this.visibility = class_368.class_369.field_2209;
    }

    public boolean hasProgressBar() {
        return this.hasProgressBar;
    }

    public float getProgress() {
        return this.progress;
    }

    public void method_1992(float progress) {
        this.progress = progress;
    }

    @Override
    public void setToastVisibility(boolean visible) {
        if (visible) {
            this.show();
        } else {
            this.method_1993();
        }
    }
}

