/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.structure;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.structure.StructureTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class LavenderStructures {
    private static final Map<class_2960, JsonObject> PENDING_STRUCTURES = new HashMap<class_2960, JsonObject>();
    private static final Map<class_2960, StructureTemplate> LOADED_STRUCTURES = new HashMap<class_2960, StructureTemplate>();
    private static boolean tagsAvailable = false;

    @ApiStatus.Internal
    public static void initialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ReloadListener());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            tagsAvailable = false;
        });
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            tagsAvailable = true;
            LavenderStructures.tryParseStructures();
        });
    }

    public static Set<class_2960> loadedStructures() {
        return Collections.unmodifiableSet(LOADED_STRUCTURES.keySet());
    }

    @Nullable
    public static StructureTemplate get(class_2960 structureId) {
        return LOADED_STRUCTURES.get(structureId);
    }

    private static void tryParseStructures() {
        LOADED_STRUCTURES.clear();
        PENDING_STRUCTURES.forEach((identifier, pending) -> {
            try {
                LOADED_STRUCTURES.put((class_2960)identifier, StructureTemplate.parse(identifier, pending));
            }
            catch (JsonParseException e) {
                Lavender.LOGGER.warn("Failed to load structure info {}", identifier, (Object)e);
            }
        });
    }

    private static class ReloadListener
    extends class_4309
    implements IdentifiableResourceReloadListener {
        public ReloadListener() {
            super(new GsonBuilder().setLenient().disableHtmlEscaping().create(), "lavender/structures");
        }

        public class_2960 getFabricId() {
            return Lavender.id("structure_info_loader");
        }

        protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
            PENDING_STRUCTURES.clear();
            prepared.forEach((resourceId, jsonElement) -> {
                if (!jsonElement.isJsonObject()) {
                    return;
                }
                PENDING_STRUCTURES.put((class_2960)resourceId, jsonElement.getAsJsonObject());
            });
            if (tagsAvailable) {
                LavenderStructures.tryParseStructures();
            }
        }
    }
}

