/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.md.compiler;

import com.google.common.primitives.Ints;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.lavendermd.feature.OwoUITemplateFeature;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.util.Map;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookCompiler
extends OwoUICompiler {
    private static final class_2583 UNICODE_FONT_STYLE = class_2583.field_24360.method_27704(class_310.field_24211);
    private final FlowLayout resultContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
    private final ComponentSource bookComponentSource;
    private boolean addImageBackground = false;

    public BookCompiler(ComponentSource bookComponentSource) {
        this.push(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()));
        this.bookComponentSource = bookComponentSource;
    }

    protected LabelComponent makeLabel(class_5250 text) {
        return new BookLabelComponent((class_2561)text.method_27694(style -> style.method_27702(UNICODE_FONT_STYLE))).color(Color.BLACK).lineHeight(7);
    }

    public void visitImage(class_2960 image, String description, boolean fit) {
        this.addImageBackground = fit;
        super.visitImage(image, description, fit);
    }

    public void visitHorizontalRule() {
        this.append(this.bookComponentSource.builtinTemplate(Component.class, "horizontal-rule"));
    }

    public void visitPageBreak() {
        this.resultContainer.child((Component)this.components.peek());
        this.pop();
        this.push(Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()));
    }

    protected void append(Component component) {
        if (this.addImageBackground) {
            this.addImageBackground = false;
            if (component instanceof StackLayout) {
                StackLayout stack = (StackLayout)component;
                ((Component)stack.children().get(0)).margins(Insets.of((int)3));
                stack.child(0, (Component)this.bookComponentSource.builtinTemplate(TextureComponent.class, "fit-image-background"));
            }
        }
        super.append(component);
    }

    public ParentComponent compile() {
        this.pop();
        return super.compile();
    }

    public String name() {
        return "lavender_builtin_book";
    }

    @FunctionalInterface
    public static interface ComponentSource
    extends OwoUITemplateFeature.TemplateProvider {
        public <C extends Component> C template(UIModel var1, Class<C> var2, String var3, Map<String, String> var4);

        default public <C extends Component> C template(class_2960 model, Class<C> expectedClass, String templateName, Map<String, String> templateParams) {
            return this.template(UIModelLoader.get((class_2960)model), expectedClass, templateName, templateParams);
        }

        default public <C extends Component> C builtinTemplate(Class<C> expectedComponentClass, String name, Map<String, String> params) {
            return this.template(UIModelLoader.get((class_2960)Lavender.id("book_components")), expectedComponentClass, name, params);
        }

        default public <C extends Component> C builtinTemplate(Class<C> expectedComponentClass, String name) {
            return this.builtinTemplate(expectedComponentClass, name, Map.of());
        }

        default public <C extends Component> C template(UIModel model, Class<C> expectedComponentClass, String name) {
            return this.template(model, expectedComponentClass, name, Map.of());
        }
    }

    public static class BookLabelComponent
    extends LabelComponent {
        @Nullable
        private LavenderBookScreen owner;

        protected BookLabelComponent(class_2561 text) {
            super(text);
            this.margins(Insets.horizontal((int)1));
            this.textClickHandler(style -> {
                if (style == null || this.owner == null) {
                    return false;
                }
                class_2558 clickEvent = style.method_10970();
                if (clickEvent != null && clickEvent.method_10845() == class_2558.class_2559.field_11749 && clickEvent.method_10844().startsWith("^")) {
                    LinkTarget linkTarget = this.resolveLinkTarget(clickEvent.method_10844());
                    if (linkTarget != null && linkTarget.entry != null) {
                        this.owner.navPush(new LavenderBookScreen.NavFrame(new LavenderBookScreen.EntryPageSupplier(this.owner, linkTarget.entry), linkTarget.page));
                        return true;
                    }
                    return false;
                }
                return this.owner.method_25430((class_2583)style);
            });
        }

        public void setOwner(@NotNull LavenderBookScreen screen) {
            this.owner = screen;
        }

        @Nullable
        protected LinkTarget resolveLinkTarget(String link) {
            class_2960 entryId;
            if (this.owner == null) {
                return null;
            }
            String rawLinkText = link.substring(1);
            int targetPage = 0;
            int pageSeparatorIndex = rawLinkText.indexOf(35);
            if (pageSeparatorIndex > 0) {
                Integer parsed = Ints.tryParse((String)rawLinkText.substring(pageSeparatorIndex + 1));
                if (parsed == null) {
                    return null;
                }
                targetPage = Math.max(0, (parsed - 1) / 2 * 2);
                rawLinkText = rawLinkText.substring(0, pageSeparatorIndex);
            }
            if ((entryId = class_2960.method_12829((String)rawLinkText)) == null) {
                return null;
            }
            Entry entry = this.owner.book.entryById(entryId);
            if (entry == null) {
                return null;
            }
            return new LinkTarget(entry.canPlayerView(class_310.method_1551().field_1724) ? entry : null, targetPage);
        }

        protected class_2583 styleAt(int mouseX, int mouseY) {
            class_2583 style = super.styleAt(mouseX, mouseY);
            if (style == null) {
                return null;
            }
            class_2568 event = style.method_10969();
            if (this.owner != null && event != null && event.method_10892() == class_2568.class_5247.field_24342 && ((class_2561)event.method_10891(class_2568.class_5247.field_24342)).getString().startsWith("^")) {
                String rawLink = ((class_2561)event.method_10891(class_2568.class_5247.field_24342)).getString();
                LinkTarget linkTarget = this.resolveLinkTarget(rawLink);
                style = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)(linkTarget != null ? (linkTarget.entry != null ? class_2561.method_43470((String)linkTarget.entry.title()) : class_2561.method_43471((String)"text.lavender.locked_internal_link")) : class_2561.method_43469((String)"text.lavender.invalid_internal_link", (Object[])new Object[]{rawLink}))));
            }
            return style;
        }

        protected record LinkTarget(Entry entry, int page) {
        }
    }
}

