/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.structure.LavenderStructures;
import io.wispforest.lavender.structure.StructureTemplate;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StructureComponent
extends BaseComponent {
    private final StructureTemplate structure;
    private final int displayAngle;
    private int visibleLayer = -1;

    public StructureComponent(StructureTemplate structure, int displayAngle) {
        this.structure = structure;
        this.displayAngle = displayAngle;
        this.cursorStyle(CursorStyle.HAND);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        class_310 client = class_310.method_1551();
        class_4597.class_4598 entityBuffers = client.method_22940().method_23000();
        float scale = Math.min(this.width, this.height);
        scale /= (float)Math.max(this.structure.xSize, Math.max(this.structure.ySize, this.structure.zSize));
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 100.0f);
        matrices.method_22905(scale /= 1.625f, -scale, scale);
        matrices.method_22907(class_7833.field_40714.rotationDegrees((float)this.displayAngle));
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)((double)System.currentTimeMillis() / 75.0 % 360.0)));
        matrices.method_46416((float)this.structure.xSize / -2.0f, (float)this.structure.ySize / -2.0f, (float)this.structure.zSize / -2.0f);
        this.structure.forEachPredicate((blockPos, predicate) -> {
            if (this.visibleLayer != -1 && this.visibleLayer != blockPos.method_10264()) {
                return;
            }
            matrices.method_22903();
            matrices.method_46416((float)blockPos.method_10263(), (float)blockPos.method_10264(), (float)blockPos.method_10260());
            client.method_1541().method_3353(predicate.preview(), matrices, (class_4597)entityBuffers, 240, class_4608.field_21444);
            matrices.method_22909();
        });
        matrices.method_22909();
        class_308.method_24210();
        entityBuffers.method_22993();
        class_308.method_24211();
        if (StructureOverlayRenderer.isShowingOverlay(this.structure.id)) {
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43471((String)"text.lavender.structure_component.active_overlay_hint"), this.x + this.width - 5 - client.field_1772.method_1727("\u2693"), this.y + this.height - 9 - 5, 0, false);
            this.tooltip((class_2561)class_2561.method_43471((String)"text.lavender.structure_component.hide_hint"));
        } else {
            this.tooltip((class_2561)class_2561.method_43471((String)"text.lavender.structure_component.place_hint"));
        }
    }

    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        boolean result = super.onMouseDown(mouseX, mouseY, button);
        if (button != 0) {
            return result;
        }
        if (StructureOverlayRenderer.isShowingOverlay(this.structure.id)) {
            StructureOverlayRenderer.removeAllOverlays(this.structure.id);
        } else {
            StructureOverlayRenderer.addPendingOverlay(this.structure.id);
            StructureOverlayRenderer.restrictVisibleLayer(this.structure.id, this.visibleLayer);
            class_310.method_1551().method_1507(null);
        }
        return true;
    }

    public StructureComponent visibleLayer(int visibleLayer) {
        StructureOverlayRenderer.restrictVisibleLayer(this.structure.id, visibleLayer);
        this.visibleLayer = visibleLayer;
        return this;
    }

    public static StructureComponent parse(Element element) {
        UIParsing.expectAttributes((Element)element, (String[])new String[]{"structure-id"});
        class_2960 structureId = class_2960.method_12829((String)element.getAttribute("structure-id"));
        if (structureId == null) {
            throw new UIModelParsingException("Invalid structure id '" + element.getAttribute("structure-id") + "'");
        }
        StructureTemplate structure = LavenderStructures.get(structureId);
        if (structure == null) {
            throw new UIModelParsingException("Unknown structure '" + structureId + "'");
        }
        int displayAngle = 35;
        if (element.hasAttribute("display-angle")) {
            displayAngle = UIParsing.parseSignedInt((Node)element.getAttributeNode("display-angle"));
        }
        return new StructureComponent(structure, displayAngle);
    }
}

