/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.gson.JsonParseException;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavendermd.util.StringNibbler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Book {
    private static final Pattern MACRO_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    private static final Pattern MACRO_ARG_PATTERN = Pattern.compile("\\$\\d+");
    private final class_2960 id;
    @Nullable
    private final class_2960 texture;
    @Nullable
    private final class_2960 dynamicBookModel;
    @Nullable
    private final class_2960 introEntry;
    private final boolean displayCompletion;
    private final Map<String, String> zeroArgMacros = new HashMap<String, String>();
    private final Map<Pattern, Macro> macros = new HashMap<Pattern, Macro>();
    @Nullable
    private final class_2960 extend;
    @Nullable
    private Book resolvedExtend = null;
    private final Map<class_2960, Category> categories = new HashMap<class_2960, Category>();
    private final Collection<Category> categoriesView = Collections.unmodifiableCollection(this.categories.values());
    private final Map<class_2960, Entry> entriesById = new HashMap<class_2960, Entry>();
    private final Collection<Entry> entriesView = Collections.unmodifiableCollection(this.entriesById.values());
    private final Map<Category, List<Entry>> entriesByCategory = new HashMap<Category, List<Entry>>();
    private final Map<class_1792, Entry> entriesByAssociatedItem = new HashMap<class_1792, Entry>();
    private final List<Entry> orphanedEntries = new ArrayList<Entry>();
    private final Collection<Entry> orphanedEntriesView = Collections.unmodifiableCollection(this.orphanedEntries);
    @Nullable
    private Entry landingPage = null;

    public Book(class_2960 id, @Nullable class_2960 extend, @Nullable class_2960 texture, @Nullable class_2960 dynamicBookModel, @Nullable class_2960 introEntry, boolean displayCompletion, Map<String, String> macros) {
        this.id = id;
        this.extend = extend;
        this.texture = texture;
        this.dynamicBookModel = dynamicBookModel;
        this.introEntry = introEntry;
        this.displayCompletion = displayCompletion;
        macros.forEach((macro, replacement) -> {
            int argCount = (int)MACRO_ARG_PATTERN.matcher((CharSequence)replacement).results().count();
            if (argCount > 0) {
                if (!MACRO_NAME_PATTERN.asPredicate().test((String)macro)) {
                    throw new JsonParseException("Parametrized macro '" + macro + "' contains invalid characters. Parametrized macro names must only contain '[a-zA-Z0-9_-]'");
                }
                ArrayList<String> parts = new ArrayList<String>();
                IntArrayList argIndices = new IntArrayList();
                StringBuilder result = new StringBuilder((String)replacement);
                Matcher argMatcher = MACRO_ARG_PATTERN.matcher(result);
                while (argMatcher.find()) {
                    parts.add(replacement.substring(0, argMatcher.start()));
                    argIndices.add(Integer.parseInt(argMatcher.group().substring(1)) - 1);
                    result.delete(0, argMatcher.end());
                    argMatcher.reset();
                }
                parts.add(result.toString());
                this.macros.put(Pattern.compile(Pattern.quote(macro) + "\\(" + Stream.generate(() -> "\\S").limit(argCount).collect(Collectors.joining(",")) + "\\)"), new Macro(parts, (IntList)argIndices));
            } else {
                this.zeroArgMacros.put((String)macro, (String)replacement);
            }
        });
    }

    public class_2960 id() {
        return this.id;
    }

    public boolean displayCompletion() {
        return this.displayCompletion;
    }

    public Collection<Entry> entries() {
        return this.entriesView;
    }

    public Collection<Entry> orphanedEntries() {
        return this.orphanedEntriesView;
    }

    @Nullable
    public Entry introEntry() {
        return this.introEntry != null ? this.entryById(this.introEntry) : null;
    }

    @Nullable
    public Entry entryById(class_2960 entryId) {
        return this.entriesById.get(entryId);
    }

    @Nullable
    public Entry entryByAssociatedItem(class_1792 associatedItem) {
        return this.entriesByAssociatedItem.get(associatedItem);
    }

    @Nullable
    public Collection<Entry> entriesByCategory(Category category) {
        List<Entry> entries = this.entriesByCategory.get(category);
        if (entries == null) {
            return null;
        }
        return Collections.unmodifiableCollection(entries);
    }

    public Collection<Category> categories() {
        return this.categoriesView;
    }

    @Nullable
    public Category categoryById(class_2960 categoryId) {
        return this.categories.get(categoryId);
    }

    public boolean shouldDisplayCategory(Category category, class_746 player) {
        Collection<Entry> entries = this.entriesByCategory(category);
        if (entries == null) {
            return false;
        }
        boolean anyVisible = false;
        for (Entry entry : entries) {
            if (!entry.canPlayerView(player)) continue;
            anyVisible = true;
        }
        return anyVisible;
    }

    @Nullable
    public Entry landingPage() {
        return this.landingPage;
    }

    @Nullable
    public class_2960 texture() {
        return this.texture;
    }

    @Nullable
    public class_2960 dynamicBookModel() {
        return this.dynamicBookModel;
    }

    public int countVisibleEntries(class_746 player) {
        int visible = 0;
        for (Entry entry : this.entriesById.values()) {
            if (!entry.canPlayerView(player)) continue;
            ++visible;
        }
        return visible;
    }

    String expandMacros(class_2960 entry, String input) {
        StringBuilder builder = new StringBuilder(input);
        this.zeroArgMacros.forEach((pattern, replacement) -> {
            int replaceIndex = builder.indexOf((String)pattern);
            while (replaceIndex != -1) {
                builder.replace(replaceIndex, replaceIndex + pattern.length(), (String)replacement);
                replaceIndex = builder.indexOf((String)pattern, replaceIndex + replacement.length());
            }
        });
        int scans = 0;
        boolean anyExpansions = true;
        while (scans < 1000 && anyExpansions) {
            anyExpansions = false;
            for (Pattern pattern2 : this.macros.keySet()) {
                Macro replacement2 = this.macros.get(pattern2);
                Matcher matcher = pattern2.matcher(builder);
                while (scans < 1000 && matcher.find()) {
                    ++scans;
                    anyExpansions = true;
                    String match = matcher.group();
                    StringNibbler argsNibbler = new StringNibbler(match.substring(match.indexOf(40) + 1, match.length() - 1));
                    ArrayList<String> args = new ArrayList<String>();
                    while (argsNibbler.hasNext()) {
                        args.add(argsNibbler.consumeEscapedString(',', true));
                    }
                    builder.replace(matcher.start(), matcher.end(), replacement2.apply(args));
                    matcher.reset();
                }
            }
        }
        if (scans >= 1000) {
            Lavender.LOGGER.warn("Preprocessing of entry {} in book {} failed: Macro expansion proceeded for over 1000 scans, a circular macro invocation is likely", (Object)entry, (Object)this.id);
            return "{red}**Entry processing failed:**{}\n\n\nMacro expansion proceeded for over 1000 scans without reaching\na result - this is almost definitely due to a circular macro invocation\n";
        }
        return builder.toString();
    }

    void setLandingPage(@NotNull Entry landingPage) {
        this.landingPage = landingPage;
    }

    void addEntry(Entry entry) {
        if (this.resolvedExtend != null) {
            this.resolvedExtend.addEntry(entry);
        } else {
            this.entriesById.put(entry.id(), entry);
            entry.associatedItems().forEach(item -> this.entriesByAssociatedItem.put((class_1792)item, entry));
            if (this.categories.containsKey(entry.category())) {
                this.entriesByCategory.computeIfAbsent(this.categories.get(entry.category()), $ -> new ArrayList()).add(entry);
            } else if (entry.category() == null) {
                this.orphanedEntries.add(entry);
            } else {
                throw new RuntimeException("Could not load entry '" + entry.id() + "' because category '" + entry.category() + "' was not found in book '" + this.effectiveId() + "'");
            }
        }
    }

    void addCategory(Category category) {
        if (this.resolvedExtend != null) {
            this.resolvedExtend.addCategory(category);
        } else {
            this.categories.put(category.id(), category);
        }
    }

    boolean tryResolveExtension() {
        if (this.extend == null) {
            return true;
        }
        this.resolvedExtend = BookLoader.get(this.extend);
        return this.resolvedExtend != null;
    }

    class_2960 effectiveId() {
        return this.resolvedExtend != null ? this.resolvedExtend.effectiveId() : this.id;
    }

    public record Macro(List<String> parts, IntList argIndices) {
        String apply(List<String> args) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.argIndices.size(); ++i) {
                result.append(this.parts.get(i));
                int argIndex = this.argIndices.getInt(i);
                result.append(argIndex - 1 < args.size() ? args.get(i) : "");
            }
            result.append(this.parts.get(this.parts.size() - 1));
            return result.toString();
        }
    }

    public static interface BookmarkableElement {
        public String title();

        public class_1799 icon();
    }
}

