/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity.events;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import org.apache.commons.lang3.function.TriFunction;

public class EntityMountEvents {
    public static final Event<Mount> MOUNT = EventFactory.createArrayBacked(Mount.class, callbacks -> (vehicle, passenger) -> {
        for (Mount callback : callbacks) {
            if (callback.canStartRiding(vehicle, passenger)) continue;
            return false;
        }
        return true;
    });
    public static final Event<Dismount> DISMOUNT = EventFactory.createArrayBacked(Dismount.class, callbacks -> (vehicle, passenger) -> {
        for (Dismount callback : callbacks) {
            if (callback.onStopRiding(vehicle, passenger)) continue;
            return false;
        }
        return true;
    });

    public static void registerForBoth(TriFunction<class_1297, class_1297, Boolean, Boolean> listener) {
        MOUNT.register((vehicle, passenger) -> (Boolean)listener.apply((Object)vehicle, (Object)passenger, (Object)true));
        DISMOUNT.register((vehicle, passenger) -> (Boolean)listener.apply((Object)vehicle, (Object)passenger, (Object)false));
    }

    @FunctionalInterface
    public static interface Mount {
        public boolean canStartRiding(class_1297 var1, class_1297 var2);
    }

    @FunctionalInterface
    public static interface Dismount {
        public boolean onStopRiding(class_1297 var1, class_1297 var2);
    }
}

