/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.data.manipulation.impl;

import io.gitlab.jfronny.commons.LazySupplier;
import io.gitlab.jfronny.libjf.data.manipulation.api.UserResourceEvents;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ResourcePackHook {
    private static final Map<Long, Boolean> disabled = new HashMap<Long, Boolean>();

    @ApiStatus.Internal
    public static void setDisabled(boolean disabled) {
        ResourcePackHook.disabled.put(Thread.currentThread().getId(), disabled);
    }

    @ApiStatus.Internal
    public static boolean isDisabled() {
        return disabled.getOrDefault(Thread.currentThread().getId(), false);
    }

    public static class_7367<InputStream> hookOpenRoot(class_7367<InputStream> value, class_3262 pack, String[] fileName) {
        if (ResourcePackHook.isDisabled()) {
            return value;
        }
        return ((UserResourceEvents.OpenRoot)UserResourceEvents.OPEN_ROOT.invoker()).openRoot(fileName, value, pack);
    }

    public static class_7367<InputStream> hookOpen(class_7367<InputStream> value, class_3262 pack, class_3264 type, class_2960 id) {
        if (ResourcePackHook.isDisabled()) {
            return value;
        }
        return ((UserResourceEvents.Open)UserResourceEvents.OPEN.invoker()).open(type, id, value, pack);
    }

    public static class_3262.class_7664 hookFindResources(class_3262 pack, class_3264 type, String namespace, String prefix, class_3262.class_7664 target) {
        if (ResourcePackHook.isDisabled()) {
            return target;
        }
        return ((UserResourceEvents.FindResource)UserResourceEvents.FIND_RESOURCE.invoker()).findResources(type, namespace, prefix, target, pack);
    }

    public static <T> T hookParseMetadata(T value, class_3262 pack, class_3270<T> reader) throws IOException {
        if (ResourcePackHook.isDisabled()) {
            return value;
        }
        return ((UserResourceEvents.ParseMetadata)UserResourceEvents.PARSE_METADATA.invoker()).parseMetadata(reader, new LazySupplier(value), pack);
    }

    public static <T> T hookParseMetadataEx(IOException ex, class_3262 pack, class_3270<T> reader) throws IOException {
        if (ResourcePackHook.isDisabled()) {
            throw ex;
        }
        try {
            return ResourcePackHook.hookParseMetadata(null, pack, reader);
        }
        catch (Throwable t) {
            ex.addSuppressed(t);
            throw ex;
        }
    }
}

