/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.data.manipulation.api;

import io.gitlab.jfronny.commons.LazySupplier;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.data.manipulation.impl.ResourcePackHook;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_7367;

public class UserResourceEvents {
    public static final Event<OpenRoot> OPEN_ROOT = EventFactory.createArrayBacked(OpenRoot.class, listeners -> (fileName, previous, pack) -> {
        class_7367<InputStream> lazy = previous;
        for (OpenRoot listener : listeners) {
            lazy = listener.openRoot(fileName, lazy, pack);
        }
        return lazy;
    });
    public static final Event<Open> OPEN = EventFactory.createArrayBacked(Open.class, listeners -> (type, id, previous, pack) -> {
        class_7367<InputStream> lazy = previous;
        for (Open listener : listeners) {
            lazy = listener.open(type, id, lazy, pack);
        }
        return lazy;
    });
    public static final Event<FindResource> FIND_RESOURCE = EventFactory.createArrayBacked(FindResource.class, listeners -> (type, namespace, prefix, previous, pack) -> {
        class_3262.class_7664 lazy = previous;
        for (FindResource listener : listeners) {
            lazy = listener.findResources(type, namespace, prefix, lazy, pack);
        }
        return lazy;
    });
    public static final Event<ParseMetadata> PARSE_METADATA = EventFactory.createArrayBacked(ParseMetadata.class, ParseMetadataHandler::new);

    public static <TVal, TEx extends Throwable> TVal disable(ThrowingSupplier<TVal, TEx> then) throws TEx {
        try {
            ResourcePackHook.setDisabled(true);
            Object object = then.get();
            return (TVal)object;
        }
        finally {
            ResourcePackHook.setDisabled(false);
        }
    }

    public static <TEx extends Throwable> void disable(ThrowingRunnable<TEx> then) throws TEx {
        try {
            ResourcePackHook.setDisabled(true);
            then.run();
        }
        finally {
            ResourcePackHook.setDisabled(false);
        }
    }

    public static interface FindResource {
        public class_3262.class_7664 findResources(class_3264 var1, String var2, String var3, class_3262.class_7664 var4, class_3262 var5);
    }

    public static interface Open {
        public class_7367<InputStream> open(class_3264 var1, class_2960 var2, class_7367<InputStream> var3, class_3262 var4);
    }

    public static interface OpenRoot {
        public class_7367<InputStream> openRoot(String[] var1, class_7367<InputStream> var2, class_3262 var3);
    }

    public static interface ParseMetadata {
        public <T> T parseMetadata(class_3270<T> var1, Supplier<T> var2, class_3262 var3) throws IOException;
    }

    private static class ParseMetadataHandler
    implements ParseMetadata {
        private final ParseMetadata[] listeners;

        public ParseMetadataHandler(ParseMetadata[] listeners) {
            this.listeners = listeners;
        }

        @Override
        public <T> T parseMetadata(class_3270<T> reader, Supplier<T> previous, class_3262 pack) throws IOException {
            LazySupplier lazy = new LazySupplier(previous);
            for (ParseMetadata listener : this.listeners) {
                lazy = lazy.andThen(supplier -> {
                    try {
                        return listener.parseMetadata(reader, supplier, pack);
                    }
                    catch (IOException e) {
                        LibJf.LOGGER.error("Could not call ResourcePack.OPEN_ROOT listener", (Throwable)e);
                        return null;
                    }
                });
            }
            return (T)lazy.get();
        }
    }
}

