/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.tag;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2474;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_6862;

public class TagGen {
    private static final List<TagGen> READY_TO_GEN = new ArrayList<TagGen>();
    private final List<NonNullConsumer<RegistrateTagsProvider<class_2248>>> blockTagGen;
    private final List<NonNullConsumer<RegistrateTagsProvider<class_3611>>> fluidTagGen;
    private final List<NonNullConsumer<RegistrateTagsProvider<class_1792>>> itemTagGen;

    private TagGen(List<NonNullConsumer<RegistrateTagsProvider<class_2248>>> blockTagGen, List<NonNullConsumer<RegistrateTagsProvider<class_3611>>> fluidTagGen, List<NonNullConsumer<RegistrateTagsProvider<class_1792>>> itemTagGen) {
        this.blockTagGen = blockTagGen;
        this.fluidTagGen = fluidTagGen;
        this.itemTagGen = itemTagGen;
    }

    public static void genAll() {
        for (TagGen tagGen : READY_TO_GEN) {
            for (NonNullConsumer<RegistrateTagsProvider<class_2248>> nonNullConsumer : tagGen.blockTagGen) {
                Create.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, nonNullConsumer);
            }
            for (NonNullConsumer<RegistrateTagsProvider<class_2248>> nonNullConsumer : tagGen.itemTagGen) {
                Create.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, nonNullConsumer);
            }
            for (NonNullConsumer<RegistrateTagsProvider<class_2248>> nonNullConsumer : tagGen.fluidTagGen) {
                Create.REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, nonNullConsumer);
            }
        }
    }

    public void activate() {
        READY_TO_GEN.add(this);
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(new class_6862[]{class_3481.field_33713}).tag(new class_6862[]{class_3481.field_33715});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(new class_6862[]{class_3481.field_33713});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(new class_6862[]{class_3481.field_33715});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<class_1747, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return b -> {
            for (String p : path) {
                b.tag(new class_6862[]{AllTags.forgeBlockTag((String)p)});
            }
            ItemBuilder item = b.item();
            for (String p : path) {
                item.tag(new class_6862[]{AllTags.forgeItemTag((String)p)});
            }
            return item;
        };
    }

    public static <T extends class_2474.class_5124<?>> T addOptional(T appender, Mods mod, String id) {
        appender.method_35922(mod.asResource(id));
        return appender;
    }

    public static <T extends class_2474.class_5124<?>> T addOptional(T appender, Mods mod, String ... ids) {
        for (String id : ids) {
            appender.method_35922(mod.asResource(id));
        }
        return appender;
    }

    public static class Builder {
        private final List<NonNullConsumer<RegistrateTagsProvider<class_2248>>> blockTagGen = new ArrayList<NonNullConsumer<RegistrateTagsProvider<class_2248>>>();
        private final List<NonNullConsumer<RegistrateTagsProvider<class_3611>>> fluidTagGen = new ArrayList<NonNullConsumer<RegistrateTagsProvider<class_3611>>>();
        private final List<NonNullConsumer<RegistrateTagsProvider<class_1792>>> itemTagGen = new ArrayList<NonNullConsumer<RegistrateTagsProvider<class_1792>>>();

        public Builder addItemTagFactory(NonNullConsumer<RegistrateTagsProvider<class_1792>> consumer) {
            this.itemTagGen.add(consumer);
            return this;
        }

        public Builder addBlockTagFactory(NonNullConsumer<RegistrateTagsProvider<class_2248>> consumer) {
            this.blockTagGen.add(consumer);
            return this;
        }

        public Builder addFluidTagFactory(NonNullConsumer<RegistrateTagsProvider<class_3611>> consumer) {
            this.fluidTagGen.add(consumer);
            return this;
        }

        public TagGen build() {
            return new TagGen(this.blockTagGen, this.fluidTagGen, this.itemTagGen);
        }
    }
}

