/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.lang;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.util.function.Supplier;

abstract class LangPartial {
    protected final String modid;
    protected final String display;

    LangPartial(String modid, String display) {
        this.modid = modid;
        this.display = display;
    }

    public String getDisplay() {
        return this.display;
    }

    public abstract JsonObject provide();

    static class Gen
    extends LangPartial {
        private final Supplier<JsonObject> provider;
        private final Runnable preTask;

        Gen(String modid, String display, Supplier<JsonObject> provider, Runnable preTask) {
            super(modid, display);
            this.provider = provider;
            this.preTask = preTask;
        }

        @Override
        public JsonObject provide() {
            this.preTask.run();
            return this.provider.get();
        }
    }

    static class Merge
    extends LangPartial {
        private final String filename;

        Merge(String modid, String display, String filename) {
            super(modid, display);
            this.filename = filename;
        }

        @Override
        public JsonObject provide() {
            String filepath = "assets/" + this.modid + "/lang/default/" + this.filename + ".json";
            JsonElement element = FilesHelper.loadJsonResource((String)filepath);
            if (element == null) {
                throw new IllegalStateException(String.format("Could not find default lang file: %s", filepath));
            }
            return element.getAsJsonObject();
        }
    }
}

