/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.lang;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_3518;
import net.minecraft.class_7403;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import plus.dragons.createdragonlib.lang.LangPartial;
import plus.dragons.createdragonlib.mixin.DataGeneratorAccessor;

@ApiStatus.Internal
class LangMerger
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CATEGORY_HEADER = "\t\"_\": \"->------------------------]  %s  [------------------------<-\",";
    private final String modid;
    private final String name;
    private final List<Object> mergedLangData = new ArrayList<Object>();
    private final Map<String, List<Object>> populatedLangData = new HashMap<String, List<Object>>();
    private final Map<String, Map<String, String>> allLocalizedEntries = new HashMap<String, Map<String, String>>();
    private final Map<String, MutableInt> missingTranslationTally = new HashMap<String, MutableInt>();
    private final Map<String, MutableInt> existingButActuallyMissingTranslationTally = new HashMap<String, MutableInt>();
    final List<LangPartial> partials = new ArrayList<LangPartial>();
    class_2403 dataGenerator;
    List<String> ignore = new ArrayList<String>();

    LangMerger(String name, String modid) {
        this.modid = modid;
        this.name = name;
    }

    public String method_10321() {
        return this.name + " Lang Merger";
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        Path path = ((DataGeneratorAccessor)this.dataGenerator).getRootOutputFolder().resolve("assets/" + this.modid + "/lang/en_us.json");
        return CompletableFuture.runAsync(() -> {
            for (Pair<String, JsonElement> pair : this.getAllLocalizationFiles()) {
                String langType = (String)pair.getKey();
                if (!((JsonElement)pair.getRight()).isJsonObject()) continue;
                HashMap localizedEntries = new HashMap();
                JsonObject jsonObject = ((JsonElement)pair.getRight()).getAsJsonObject();
                this.existingButActuallyMissingTranslationTally.put(langType, new MutableInt(0));
                jsonObject.entrySet().stream().forEachOrdered(entry -> {
                    String key = (String)entry.getKey();
                    if (key.startsWith("_")) {
                        return;
                    }
                    String value = ((JsonElement)entry.getValue()).getAsString();
                    if (value.startsWith("UNLOCALIZED: ")) {
                        this.existingButActuallyMissingTranslationTally.get(langType).increment();
                    }
                    localizedEntries.put(key, value);
                });
                this.allLocalizedEntries.put(langType, localizedEntries);
                this.populatedLangData.put(langType, new ArrayList());
                this.missingTranslationTally.put(langType, new MutableInt(0));
            }
            try {
                this.collectExistingEntries(path);
                this.collectEntries();
                if (this.mergedLangData.isEmpty()) {
                    return;
                }
                this.save(cache, this.mergedLangData, -1, path, "Merging en_us.json with hand-written lang entries...");
                for (Map.Entry entry2 : this.populatedLangData.entrySet()) {
                    String key = (String)entry2.getKey();
                    Path populatedLangPath = ((DataGeneratorAccessor)this.dataGenerator).getRootOutputFolder().resolve("assets/" + this.modid + "/lang/unfinished/" + key);
                    this.save(cache, (List)entry2.getValue(), this.missingTranslationTally.get(key).intValue() + this.existingButActuallyMissingTranslationTally.get(key).intValue(), populatedLangPath, "Populating " + key + " with missing entries...");
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        });
    }

    private boolean shouldIgnore(String key) {
        for (String string : this.ignore) {
            if (!key.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private void collectExistingEntries(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("Nothing to merge! It appears no lang was generated before me.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonobject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
            HashSet keysToRemove = new HashSet();
            MutableBoolean startErasing = new MutableBoolean();
            jsonobject.entrySet().stream().forEachOrdered(entry -> {
                String key = (String)entry.getKey();
                if (key.startsWith("advancement")) {
                    startErasing.setTrue();
                }
                if (startErasing.isFalse()) {
                    return;
                }
                keysToRemove.add(key);
            });
            jsonobject.remove("_");
            keysToRemove.forEach(arg_0 -> ((JsonObject)jsonobject).remove(arg_0));
            this.addAll("Game Elements", jsonobject);
        }
    }

    private void addAll(String header, JsonObject jsonObject) {
        header = String.format(CATEGORY_HEADER, header);
        this.writeData("\n");
        this.writeData(header);
        this.writeData("\n\n");
        MutableObject previousKey = new MutableObject((Object)"");
        jsonObject.entrySet().stream().forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            if (this.shouldIgnore(key)) {
                return;
            }
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (!((String)previousKey.getValue()).isEmpty() && this.shouldAddLineBreak(key, (String)previousKey.getValue())) {
                this.writeData("\n");
            }
            this.writeEntry(key, value);
            previousKey.setValue((Object)key);
        });
        this.writeData("\n");
    }

    private void writeData(String data) {
        this.mergedLangData.add(data);
        this.populatedLangData.values().forEach(l -> l.add(data));
    }

    private void writeEntry(String key, String value) {
        this.mergedLangData.add(new LangEntry(key, value));
        this.populatedLangData.forEach((k, l) -> {
            ForeignLangEntry entry = new ForeignLangEntry(key, value, this.allLocalizedEntries.get(k));
            if (entry.isMissing()) {
                this.missingTranslationTally.get(k).increment();
            }
            l.add(entry);
        });
    }

    protected boolean shouldAddLineBreak(String key, String previousKey) {
        if (key.endsWith(".tooltip")) {
            return true;
        }
        if (key.startsWith(this.modid + ".ponder") && key.endsWith("header")) {
            return true;
        }
        key = key.replaceFirst("\\.", "");
        previousKey = previousKey.replaceFirst("\\.", "");
        String[] split = key.split("\\.");
        String[] split2 = previousKey.split("\\.");
        if (split.length == 0 || split2.length == 0) {
            return false;
        }
        return !split[0].equals(split2[0]);
    }

    private List<Pair<String, JsonElement>> getAllLocalizationFiles() {
        ArrayList<Pair<String, JsonElement>> list = new ArrayList<Pair<String, JsonElement>>();
        String filepath = "assets/" + this.modid + "/lang/";
        try (InputStream resourceStream = ClassLoader.getSystemResourceAsStream(filepath);){
            String readLine;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(resourceStream));
            while ((readLine = bufferedReader.readLine()) != null) {
                if (!readLine.endsWith(".json") || readLine.startsWith("en_us") || readLine.startsWith("en_ud")) continue;
                list.add((Pair<String, JsonElement>)Pair.of((Object)readLine, (Object)FilesHelper.loadJsonResource((String)(filepath + readLine))));
            }
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void collectEntries() {
        for (LangPartial partial : this.partials) {
            this.addAll(partial.getDisplay(), partial.provide().getAsJsonObject());
        }
    }

    private void save(class_7403 cache, List<Object> dataIn, int missingKeys, Path target, String message) throws IOException {
        LOGGER.info(message);
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8);
        ((Writer)writer).append(this.createString(dataIn, missingKeys));
        ((Writer)writer).close();
        cache.method_43346(target, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
    }

    private String createString(List<Object> data, int missingKeys) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        if (missingKeys != -1) {
            builder.append("\t\"_\": \"Missing Localizations: ").append(missingKeys).append("\",\n");
        }
        data.forEach(builder::append);
        builder.append("\t\"_\": \"Thank you for translating ").append(this.name).append("!\"\n\n");
        builder.append("}");
        return builder.toString();
    }

    private static class LangEntry {
        static final String ENTRY_FORMAT = "\t\"%s\": %s,\n";
        private final String key;
        private final String value;

        LangEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format(ENTRY_FORMAT, this.key, GSON.toJson((Object)this.value, String.class));
        }
    }

    private static class ForeignLangEntry
    extends LangEntry {
        private final boolean missing;

        ForeignLangEntry(String key, String value, Map<String, String> localizationMap) {
            super(key, localizationMap.getOrDefault(key, "UNLOCALIZED: " + value));
            this.missing = !localizationMap.containsKey(key);
        }

        public boolean isMissing() {
            return this.missing;
        }
    }
}

