/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.lang;

import com.google.gson.JsonObject;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import java.util.Collections;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import plus.dragons.createdragonlib.advancement.AdvancementHolder;
import plus.dragons.createdragonlib.lang.LangMerger;
import plus.dragons.createdragonlib.lang.LangPartial;

public class LangFactory {
    private final String modid;
    private final LangMerger langMerger;

    private LangFactory(String name, String modid) {
        this.modid = modid;
        this.langMerger = new LangMerger(name, modid);
    }

    public static LangFactory create(String name, String modid) {
        return new LangFactory(name, modid);
    }

    public void datagen(FabricDataGenerator datagen) {
        this.langMerger.dataGenerator = datagen;
        FabricDataGenerator.Pack pack = datagen.createPack();
        pack.method_46566(output -> this.langMerger);
    }

    public LangFactory gen(String display, Supplier<JsonObject> provider, Runnable preTask) {
        this.langMerger.partials.add(new LangPartial.Gen(this.modid, display, provider, preTask));
        return this;
    }

    public LangFactory merge(String filename, String display) {
        this.langMerger.partials.add(new LangPartial.Merge(this.modid, display, filename));
        return this;
    }

    public LangFactory ponders(Runnable preTask) {
        this.langMerger.partials.add(new LangPartial.Gen(this.modid, "Ponder Content", () -> {
            JsonObject ret = new JsonObject();
            PonderLocalization.generateSceneLang();
            PonderLocalization.record((String)this.modid, (JsonObject)ret);
            return ret;
        }, preTask));
        return this;
    }

    public LangFactory advancements(Runnable preTask) {
        this.langMerger.partials.add(new LangPartial.Gen(this.modid, "Advancements", () -> AdvancementHolder.provideLangEntries(this.modid), preTask));
        return this;
    }

    public LangFactory tooltips() {
        this.langMerger.partials.add(new LangPartial.Merge(this.modid, "Item Descriptions", "tooltips"));
        return this;
    }

    public LangFactory ui() {
        this.langMerger.partials.add(new LangPartial.Merge(this.modid, "UI & Messages", "interface"));
        return this;
    }

    public LangFactory ignore(String ... entries) {
        Collections.addAll(this.langMerger.ignore, entries);
        return this;
    }
}

