/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.lang;

import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.LangNumberFormat;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Locale;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import plus.dragons.createdragonlib.lang.LangBuilder;

public class Lang {
    private final String modid;

    public Lang(String modid) {
        this.modid = modid;
    }

    public String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public String enumId(Enum<?> anEnum) {
        return anEnum.name().toLowerCase(Locale.ROOT).replace('$', '/');
    }

    public String nonPluralId(String name) {
        String asId = this.asId(name);
        return asId.endsWith("s") ? asId.substring(0, asId.length() - 1) : asId;
    }

    public LangBuilder builder() {
        return new LangBuilder(this.modid);
    }

    public LangBuilder blockName(class_2680 state) {
        return this.builder().add(state.method_26204().method_9518());
    }

    public LangBuilder itemName(class_1799 stack) {
        return this.builder().add(stack.method_7964().method_27661());
    }

    public LangBuilder fluidName(FluidStack stack) {
        return this.builder().add(stack.getDisplayName().method_27661());
    }

    public LangBuilder tooltip(class_1792 item, String suffix, Object ... args) {
        return this.builder().add(Components.translatable((String)(item.method_7876() + ".tooltip." + suffix), (Object[])args));
    }

    public LangBuilder tooltip(class_2248 block, String suffix, Object ... args) {
        return this.builder().add(Components.translatable((String)(block.method_9539() + ".tooltip." + suffix), (Object[])args));
    }

    public LangBuilder fromRL(String category, class_2960 loc, Object ... args) {
        return this.builder().add(Components.translatable((String)class_156.method_646((String)category, (class_2960)loc), (Object[])args));
    }

    public LangBuilder number(double d) {
        return this.builder().text(LangNumberFormat.format((double)d));
    }

    public LangBuilder translate(String langKey, Object ... args) {
        return this.builder().translate(langKey, args);
    }

    public LangBuilder text(String text) {
        return this.builder().text(text);
    }
}

