/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.advancement.critereon;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_195;
import net.minecraft.class_2096;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

public class AccumulativeTrigger
extends class_4558<TriggerInstance> {
    private final class_2960 id;

    public AccumulativeTrigger(class_2960 pId) {
        this.id = pId;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject pJson, @NotNull class_5258 player, @NotNull class_5257 pContext) {
        class_2096.class_2100 requirements = class_2096.class_2100.method_9056((JsonElement)pJson.get("requirement"));
        return new TriggerInstance(this.id, player, requirements);
    }

    public void trigger(class_1657 pPlayer, int change) {
        this.method_22510((class_3222)pPlayer, triggerInstance -> triggerInstance.matches(this.id, pPlayer, change));
    }

    @NotNull
    public class_2960 method_794() {
        return this.id;
    }

    private static AccumulativeData get(class_1937 level) {
        if (!(level instanceof class_3218)) {
            throw new RuntimeException("Attempted to get the data from a client world.");
        }
        class_3218 serverWorld = level.method_8503().method_30002();
        class_26 dimensionSavedDataManager = serverWorld.method_17983();
        return (AccumulativeData)dimensionSavedDataManager.method_17924(AccumulativeData::load, AccumulativeData::new, "accumulative_data");
    }

    public static class TriggerInstance
    extends class_195 {
        private final class_2096.class_2100 requirement;

        public TriggerInstance(class_2960 pCriterion, class_5258 player, class_2096.class_2100 requirement) {
            super(pCriterion, player);
            this.requirement = requirement;
        }

        public boolean matches(class_2960 resourceLocation, class_1657 player, int change) {
            AccumulativeData data = AccumulativeTrigger.get(player.method_37908());
            data.change(resourceLocation, player.method_5667(), change);
            return this.requirement.method_9054(data.get(resourceLocation, player.method_5667()));
        }

        @NotNull
        public JsonObject method_807(@NotNull class_5267 pConditions) {
            JsonObject jsonObject = super.method_807(pConditions);
            jsonObject.add("requirement", this.requirement.method_9036());
            return jsonObject;
        }
    }

    private static class AccumulativeData
    extends class_18 {
        public Table<class_2960, UUID, Integer> data = HashBasedTable.create();

        public void change(class_2960 resourceLocation, UUID playerId, int i) {
            Integer temp = (Integer)this.data.get((Object)resourceLocation, (Object)playerId);
            temp = temp == null ? 0 : temp;
            temp = temp + i;
            this.data.put((Object)resourceLocation, (Object)playerId, (Object)temp);
            this.method_80();
        }

        public int get(class_2960 resourceLocation, UUID playerId) {
            Integer ret = (Integer)this.data.get((Object)resourceLocation, (Object)playerId);
            return ret == null ? 0 : ret;
        }

        public static AccumulativeData load(class_2487 compoundNBT) {
            AccumulativeData ret = new AccumulativeData();
            if (!compoundNBT.method_10545("AccumulativeData")) {
                return ret;
            }
            List list = NBTHelper.readCompoundList((class_2499)((class_2499)compoundNBT.method_10580("AccumulativeData")), c -> new TriCell(NBTHelper.readResourceLocation((class_2487)c, (String)"TriggerId"), c.method_25926("PlayerId"), c.method_10550("Count")));
            list.forEach(triCell -> ret.data.put((Object)triCell.rl, (Object)triCell.id, (Object)triCell.i));
            return ret;
        }

        public class_2487 method_75(class_2487 pCompoundTag) {
            class_2499 dataListTag = NBTHelper.writeCompoundList(this.data.cellSet().stream().toList(), cell -> {
                class_2487 ret = new class_2487();
                NBTHelper.writeResourceLocation((class_2487)ret, (String)"TriggerId", (class_2960)((class_2960)cell.getRowKey()));
                ret.method_25927("PlayerId", (UUID)cell.getColumnKey());
                ret.method_10569("Count", ((Integer)cell.getValue()).intValue());
                return ret;
            });
            pCompoundTag.method_10566("AccumulativeData", (class_2520)dataListTag);
            return pCompoundTag;
        }

        private record TriCell(class_2960 rl, UUID id, int i) {
        }
    }
}

