/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.advancement;

import com.google.gson.JsonObject;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.utility.Components;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonlib.advancement.CreateAdvancementAccess;
import plus.dragons.createdragonlib.advancement.critereon.SimpleTrigger;
import plus.dragons.createdragonlib.advancement.critereon.TriggerFactory;
import plus.dragons.createdragonlib.mixin.CreateAdvancementConstructor;

public class AdvancementHolder {
    public static final Map<String, List<AdvancementHolder>> ENTRIES_MAP = new HashMap<String, List<AdvancementHolder>>();
    protected final class_2960 id;
    protected final class_161.class_162 builder;
    @Nullable
    protected final SimpleTrigger builtinTrigger;
    protected final String titleKey;
    protected final String descriptionKey;
    protected final String title;
    protected final String description;
    @Nullable
    protected final AdvancementHolder parent;
    @Nullable
    protected CreateAdvancement createAdvancement;
    protected class_161 advancement;

    protected AdvancementHolder(String modid, String id, class_161.class_162 builder, @Nullable AdvancementHolder parent, boolean builtin, String title, String description, TriggerFactory triggerFactory) {
        this.id = new class_2960(modid, id);
        this.builder = builder;
        this.parent = parent;
        if (builtin) {
            this.builtinTrigger = triggerFactory.simple(new class_2960(modid, "builtin/" + id));
            this.builder.method_709("builtin", (class_184)this.builtinTrigger.instance());
        } else {
            this.builtinTrigger = null;
        }
        this.titleKey = new StringJoiner(".").add("advancement").add(modid).add(id).toString();
        this.descriptionKey = this.titleKey + ".desc";
        this.title = title;
        this.description = description;
    }

    public class_2960 id() {
        return this.id;
    }

    public String titleKey() {
        return this.titleKey;
    }

    public String descriptionKey() {
        return this.descriptionKey;
    }

    public String title() {
        return this.title;
    }

    public String description() {
        return this.description;
    }

    @Nullable
    public SimpleTrigger getTrigger() {
        return this.builtinTrigger;
    }

    public CreateAdvancement asCreateAdvancement() {
        if (this.createAdvancement == null) {
            this.createAdvancement = CreateAdvancementConstructor.createInstance(this.id.method_12832(), $ -> $);
            ((CreateAdvancementAccess)this.createAdvancement).fromAdvancementHolder(this);
            if (this.createAdvancement == null) {
                throw new UnsupportedOperationException("Advancement [" + this.id + "] can not convert into CreateAdvancement!");
            }
        }
        return this.createAdvancement;
    }

    public boolean isAlreadyAwardedTo(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return true;
        }
        class_3222 sp = (class_3222)player;
        class_161 advancement = sp.method_5682().method_3851().method_12896(this.id);
        if (advancement == null) {
            return true;
        }
        return sp.method_14236().method_12882(advancement).method_740();
    }

    public void awardTo(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 sp = (class_3222)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement [" + this.id + "] uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    public void save(Consumer<class_161> consumer) {
        if (this.parent != null) {
            this.builder.method_701(this.parent.advancement);
        }
        this.advancement = this.builder.method_694(consumer, this.id.toString());
    }

    public void appendToLang(JsonObject object) {
        object.addProperty(this.titleKey(), this.title());
        object.addProperty(this.descriptionKey(), this.description());
    }

    public static JsonObject provideLangEntries(String modid) {
        JsonObject object = new JsonObject();
        List<AdvancementHolder> advancements = ENTRIES_MAP.get(modid);
        if (advancements == null) {
            return object;
        }
        for (AdvancementHolder advancement : advancements) {
            advancement.appendToLang(object);
        }
        return object;
    }

    public static class Builder {
        private final String modid;
        @Nullable
        private final class_2960 background;
        private final String id;
        private final class_161.class_162 builder = class_161.class_162.method_707();
        @Nullable
        private AdvancementHolder parent;
        private boolean builtin = true;
        private String title = "Untitled";
        private String description = "No Description";
        private class_1799 icon = class_1799.field_8037;
        private class_189 frame = class_189.field_1254;
        private boolean toast = true;
        private boolean announce = false;
        private boolean hide = false;
        private final TriggerFactory factory;

        public Builder(String modid, String id, TriggerFactory factory) {
            this.modid = modid;
            this.id = id;
            this.background = "root".equals(id) ? new class_2960(modid, "textures/gui/advancements.png") : null;
            this.factory = factory;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder icon(class_1799 stack) {
            this.icon = stack;
            return this;
        }

        public Builder icon(ItemProviderEntry<?> item) {
            return this.icon(item.asStack());
        }

        public Builder icon(class_1935 item) {
            return this.icon(new class_1799(item));
        }

        public Builder frame(class_189 frame) {
            this.frame = frame;
            return this;
        }

        public Builder toast(boolean bl) {
            this.toast = bl;
            return this;
        }

        public Builder announce(boolean bl) {
            this.announce = bl;
            return this;
        }

        public Builder hidden() {
            this.hide = true;
            return this;
        }

        public Builder externalTrigger(String key, class_184 trigger) {
            this.builder.method_709(key, trigger);
            this.builtin = false;
            return this;
        }

        public Builder parent(class_2960 id) {
            this.builder.method_701(new class_161(id, null, null, class_170.field_1167, Map.of(), new String[0][0], true));
            return this;
        }

        public Builder parent(AdvancementHolder advancement) {
            this.parent = advancement;
            return this;
        }

        public Builder transform(NonNullUnaryOperator<class_161.class_162> transform) {
            transform.apply((Object)this.builder);
            return this;
        }

        public AdvancementHolder build() {
            if (this.hide) {
                this.description = this.description + "\u00a77\n(Hidden Advancement)";
            }
            AdvancementHolder advancement = new AdvancementHolder(this.modid, this.id, this.builder, this.parent, this.builtin, this.title, this.description, this.factory);
            this.builder.method_20416(this.icon, (class_2561)Components.translatable((String)advancement.titleKey), (class_2561)Components.translatable((String)advancement.descriptionKey).method_27694(s -> s.method_36139(14393875)), this.background, this.frame, this.toast, this.announce, this.hide);
            ENTRIES_MAP.computeIfAbsent(this.modid, $ -> new ArrayList()).add(advancement);
            return advancement;
        }
    }
}

