/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonlib.advancement;

import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import plus.dragons.createdragonlib.advancement.AdvancementGen;
import plus.dragons.createdragonlib.advancement.AdvancementHolder;
import plus.dragons.createdragonlib.advancement.critereon.TriggerFactory;

public class AdvancementFactory {
    private final String modid;
    private final AdvancementGen advancementGen;
    private final TriggerFactory triggerFactory = new TriggerFactory();
    private final Runnable preTask;

    private AdvancementFactory(String name, String modid, Runnable preTask) {
        this.modid = modid;
        this.advancementGen = new AdvancementGen(name, modid);
        this.preTask = preTask;
    }

    public static AdvancementFactory create(String name, String modid, Runnable preTask) {
        return new AdvancementFactory(name, modid, preTask);
    }

    public AdvancementHolder.Builder builder(String id) {
        return new AdvancementHolder.Builder(this.modid, id, this.triggerFactory);
    }

    public TriggerFactory getTriggerFactory() {
        return this.triggerFactory;
    }

    public void datagen(FabricDataGenerator datagen) {
        this.preTask.run();
        this.advancementGen.generator = datagen;
        FabricDataGenerator.Pack pack = datagen.createPack();
        pack.method_46566(output -> this.advancementGen);
    }

    public void register() {
        this.triggerFactory.register();
    }
}

