/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.config2brigadier.util;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2588;
import org.apache.logging.log4j.LogManager;
import org.samo_lego.config2brigadier.Config2Brigadier;

public class TranslatedText
extends class_2588 {
    private static JsonObject LANG = new JsonObject();
    public static boolean SERVER_TRANSLATIONS_LOADED;

    public TranslatedText(String key, Object ... args) {
        super(SERVER_TRANSLATIONS_LOADED ? key : (LANG.has(key) ? LANG.get(key).getAsString() : key), args);
    }

    public static void setLang(String lang) {
        String langPath = String.format("/data/config2brigadier/lang/%s.json", lang);
        InputStream stream = Config2Brigadier.class.getResourceAsStream(langPath);
        try {
            if (stream == null) {
                LogManager.getLogger((String)"config2brigadier").warn("[Config2Brigadier] Language " + lang + " not available. Switching to en_us.");
                stream = Config2Brigadier.class.getResourceAsStream("/data/config2brigadier/lang/en_us.json");
            }
            assert (stream != null);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                LANG = (JsonObject)Config2Brigadier.GSON.fromJson((Reader)reader, JsonObject.class);
            }
        }
        catch (IOException | AssertionError e) {
            LogManager.getLogger((String)"Config2Brigadier").error("[Config2Brigadier] Problem occurred when trying to load language: ", (Throwable)e);
        }
        if (LANG == null) {
            LANG = new JsonObject();
        }
    }
}

